/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class GrIntroduceContextImpl
implements GrIntroduceContext {
    private static final Logger LOG = Logger.getInstance(GrIntroduceContextImpl.class);
    private final Project myProject;
    private final Editor myEditor;
    private final GrExpression myExpression;
    private final PsiElement[] myOccurrences;
    private final PsiElement myScope;
    private final GrVariable myVar;
    private final PsiElement myPlace;
    private final StringPartInfo myStringPart;

    public GrIntroduceContextImpl(Project project, Editor editor, GrExpression expression, GrVariable var, StringPartInfo stringPart, PsiElement[] occurrences, PsiElement scope) {
        this.myStringPart = stringPart;
        LOG.assertTrue(expression != null || var != null || stringPart != null);
        this.myProject = project;
        this.myEditor = editor;
        this.myExpression = expression;
        this.myOccurrences = occurrences;
        this.myScope = scope;
        this.myVar = var;
        this.myPlace = GrIntroduceHandlerBase.getCurrentPlace(expression, var, stringPart);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public GrExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiElement[] getOccurrences() {
        return this.myOccurrences;
    }

    @Override
    public PsiElement getScope() {
        return this.myScope;
    }

    @Override
    public GrVariable getVar() {
        return this.myVar;
    }

    @Override
    public StringPartInfo getStringPart() {
        return this.myStringPart;
    }

    @Override
    public PsiElement getPlace() {
        return this.myPlace;
    }
}

