/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrExpressionWrapper;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceExpressionSettingsImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;

public class GrInplaceParameterIntroducer
extends GrAbstractInplaceIntroducer<GrIntroduceParameterSettings> {
    private final IntroduceParameterInfo myInfo;
    private final TIntArrayList myParametersToRemove;
    private JBCheckBox myDelegateCB;
    private final LinkedHashSet<String> mySuggestedNames;

    public GrInplaceParameterIntroducer(IntroduceParameterInfo info, GrIntroduceContext context, OccurrencesChooser.ReplaceChoice choice) {
        super(GrIntroduceParameterHandler.REFACTORING_NAME, choice, context);
        this.myInfo = info;
        GrVariable localVar = GrIntroduceHandlerBase.resolveLocalVar(context);
        this.mySuggestedNames = GroovyIntroduceParameterUtil.suggestNames(localVar, context.getExpression(), context.getStringPart(), info.getToReplaceIn(), context.getProject());
        this.myParametersToRemove = new TIntArrayList(GroovyIntroduceParameterUtil.findParametersToRemove(info).getValues());
    }

    protected String getActionName() {
        return GrIntroduceParameterHandler.REFACTORING_NAME;
    }

    protected String[] suggestNames(boolean replaceAll, GrVariable variable) {
        return ArrayUtil.toStringArray(this.mySuggestedNames);
    }

    protected JComponent getComponent() {
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.getPreviewEditor().getComponent(), "Center");
        previewPanel.setBorder(new EmptyBorder(2, 2, 6, 2));
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                TextResult value;
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)GrInplaceParameterIntroducer.this.myEditor);
                if (templateState != null && (value = templateState.getVariableValue("PrimaryVariable")) != null) {
                    GrInplaceParameterIntroducer.this.updateTitle(GrInplaceParameterIntroducer.this.getVariable(), value.getText());
                }
            }
        };
        this.myEditor.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myDelegateCB = new JBCheckBox("Delegate via overloading method");
        this.myDelegateCB.setMnemonic('l');
        this.myDelegateCB.setFocusable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)previewPanel, "Center");
        panel.add((Component)this.myDelegateCB, "South");
        return panel;
    }

    protected void saveSettings(GrVariable variable) {
    }

    @Override
    protected void updateTitle(GrVariable variable) {
        if (variable == null) {
            return;
        }
        this.updateTitle(variable, variable.getName());
    }

    @Override
    protected void updateTitle(GrVariable variable, String value) {
        if (this.getPreviewEditor() == null || variable == null) {
            return;
        }
        PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            StringBuilder buf = new StringBuilder();
            buf.append(psiMethod.getName()).append(" (");
            boolean frst = true;
            ArrayList<TextRange> ranges2Remove = new ArrayList<TextRange>();
            TextRange addedRange = null;
            int i = 0;
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                if (frst) {
                    frst = false;
                } else {
                    buf.append(", ");
                }
                int startOffset = buf.length();
                buf.append(parameter.getType().getPresentableText()).append(" ").append(variable == parameter ? value : parameter.getName());
                int endOffset = buf.length();
                if (variable == parameter) {
                    addedRange = new TextRange(startOffset, endOffset);
                } else if (this.myParametersToRemove.contains(i)) {
                    ranges2Remove.add(new TextRange(startOffset, endOffset));
                }
                ++i;
            }
            assert (addedRange != null);
            buf.append(")");
            this.setPreviewText(buf.toString());
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.getPreviewEditor().getDocument(), (Project)this.myProject, (boolean)true);
            markupModel.removeAllHighlighters();
            for (TextRange textRange : ranges2Remove) {
                markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 0, GrInplaceParameterIntroducer.getTestAttributesForRemoval(), HighlighterTargetArea.EXACT_RANGE);
            }
            markupModel.addRangeHighlighter(addedRange.getStartOffset(), addedRange.getEndOffset(), 0, GrInplaceParameterIntroducer.getTextAttributesForAdd(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static TextAttributes getTextAttributesForAdd() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.ROUNDED_BOX);
        textAttributes.setEffectColor((Color)JBColor.RED);
        return textAttributes;
    }

    private static TextAttributes getTestAttributesForRemoval() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.STRIKEOUT);
        textAttributes.setEffectColor((Color)JBColor.BLACK);
        return textAttributes;
    }

    @Override
    protected GrVariable runRefactoring(GrIntroduceContext context, GrIntroduceParameterSettings settings, boolean processUsages) {
        GrExpressionWrapper wrapper = GrInplaceParameterIntroducer.createExpressionWrapper(context);
        if (processUsages) {
            GrIntroduceExpressionSettingsImpl patchedSettings = new GrIntroduceExpressionSettingsImpl(settings, settings.getName(), settings.declareFinal(), settings.parametersToRemove(), settings.generateDelegate(), settings.replaceFieldsWithGetters(), context.getExpression(), context.getVar(), settings.getSelectedType(), context.getVar() != null || settings.replaceAllOccurrences(), context.getVar() != null, settings.isForceReturn());
            GrIntroduceParameterProcessor processor = new GrIntroduceParameterProcessor(patchedSettings, wrapper);
            processor.run();
        } else {
            GrIntroduceParameterProcessor processor = new GrIntroduceParameterProcessor(settings, wrapper);
            processor.performRefactoring(UsageInfo.EMPTY_ARRAY);
        }
        GrParametersOwner owner = settings.getToReplaceIn();
        return (GrVariable)ArrayUtil.getLastElement((Object[])owner.getParameters());
    }

    private static GrExpressionWrapper createExpressionWrapper(GrIntroduceContext context) {
        GrExpression expression = context.getExpression();
        GrVariable var = context.getVar();
        assert (expression != null || var != null);
        GrExpression initializer = expression != null ? expression : var.getInitializerGroovy();
        return new GrExpressionWrapper(initializer);
    }

    @Override
    protected GrIntroduceParameterSettings getInitialSettingsForInplace(GrIntroduceContext context, OccurrencesChooser.ReplaceChoice choice, String[] names) {
        GrExpression expression = context.getExpression();
        GrVariable var = context.getVar();
        PsiType type = var != null ? var.getDeclaredType() : (expression != null ? expression.getType() : null);
        return new GrIntroduceExpressionSettingsImpl(this.myInfo, names[0], false, new TIntArrayList(), false, 0, expression, var, type, false, false, false);
    }

    @Override
    protected GrIntroduceParameterSettings getSettings() {
        return new GrIntroduceExpressionSettingsImpl(this.myInfo, this.getInputName(), false, this.myParametersToRemove, this.myDelegateCB.isSelected(), 0, null, null, this.getSelectedType(), this.isReplaceAllOccurrences(), false, false);
    }
}

