/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.PairFunction;
import icons.JetgroovyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class MethodOrClosureScopeChooser {
    private static final Logger LOG = Logger.getInstance(MethodOrClosureScopeChooser.class);
    @NonNls
    private static final String USE_SUPER_METHOD_OF = "Change base method";
    @NonNls
    private static final String CHANGE_USAGES_OF = "Change usages";

    public static JBPopup create(List<? extends GrParametersOwner> scopes, final Editor editor, final JBPopupOwner popupRef, final PairFunction<GrParametersOwner, PsiElement, Object> callback) {
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox superMethod = new JCheckBox(USE_SUPER_METHOD_OF, true);
        superMethod.setMnemonic('U');
        panel.add((Component)superMethod, "South");
        final JBList list = new JBList(scopes.toArray());
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)value;
                    text = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
                    boolean flags = true;
                    Icon icon = method.getIcon(1);
                    if (icon != null) {
                        this.setIcon(icon);
                    }
                } else {
                    LOG.assertTrue(value instanceof GrClosableBlock);
                    this.setIcon(JetgroovyIcons.Groovy.Groovy_16x16);
                    text = "{...}";
                }
                this.setText(text);
                return this;
            }
        });
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GrParametersOwner selectedMethod = (GrParametersOwner)list.getSelectedValue();
                if (selectedMethod == null) {
                    return;
                }
                MethodOrClosureScopeChooser.dropHighlighters(highlighters);
                MethodOrClosureScopeChooser.updateView(selectedMethod, editor, attributes, highlighters, superMethod);
            }
        });
        MethodOrClosureScopeChooser.updateView(scopes.get(0), editor, attributes, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrMethod toSearchFor;
                final GrParametersOwner ToSearchIn = (GrParametersOwner)list.getSelectedValue();
                JBPopup popup = popupRef.get();
                if (popup != null && popup.isVisible()) {
                    popup.cancel();
                }
                if (ToSearchIn instanceof GrMethod) {
                    GrMethod method = (GrMethod)ToSearchIn;
                    toSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? method.findDeepestSuperMethod() : method;
                } else {
                    toSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? ToSearchIn.getParent() : null;
                }
                IdeFocusManager.findInstance().doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        callback.fun((Object)ToSearchIn, (Object)toSearchFor);
                    }
                });
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        return JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)list).setTitle("Introduce parameter to").setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                MethodOrClosureScopeChooser.dropHighlighters(highlighters);
            }
        }).createPopup();
    }

    public static void updateView(GrParametersOwner selectedMethod, Editor editor, TextAttributes attributes, List<RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        TextRange textRange = selectedMethod.getTextRange();
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        highlighters.add(rangeHighlighter);
        if (selectedMethod instanceof GrMethod) {
            superMethod.setText(USE_SUPER_METHOD_OF);
            superMethod.setEnabled(((GrMethod)selectedMethod).findDeepestSuperMethod() != null);
        } else {
            superMethod.setText(CHANGE_USAGES_OF);
            superMethod.setEnabled(MethodOrClosureScopeChooser.findVariableToUse(selectedMethod) != null);
        }
    }

    public static GrVariable findVariableToUse(GrParametersOwner owner) {
        PsiElement resolved;
        GrExpression lValue;
        PsiElement parent = owner.getParent();
        if (parent instanceof GrVariable) {
            return (GrVariable)parent;
        }
        if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getRValue() == owner && ((GrAssignmentExpression)parent).getOperationTokenType() == GroovyTokenTypes.mASSIGN && (lValue = ((GrAssignmentExpression)parent).getLValue()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)lValue).resolve()) instanceof GrVariable) {
            return (GrVariable)resolved;
        }
        return null;
    }

    private static void dropHighlighters(List<RangeHighlighter> highlighters) {
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
    }

    public static interface JBPopupOwner {
        public JBPopup get();
    }
}

