/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.spock;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.spock.SpockUtils;
import org.jetbrains.plugins.groovy.spock.SpockVariableDescriptor;

public class SpockMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(PsiType qualifierType, PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class);
            if (method == null) {
                return;
            }
            if (aClass != method.getContainingClass()) {
                return;
            }
            Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
            String nameHint = ResolveUtil.getNameHint(processor);
            if (nameHint == null) {
                for (SpockVariableDescriptor spockVar : cachedValue.values()) {
                    if (processor.execute((PsiElement)spockVar.getVariable(), state)) continue;
                    return;
                }
            } else {
                SpockVariableDescriptor spockVar = cachedValue.get(nameHint);
                if (spockVar != null && spockVar.getNavigationElement() != place && !processor.execute((PsiElement)spockVar.getVariable(), state)) {
                    return;
                }
            }
        }
        if ((classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.METHOD)) && "get_".equals(ResolveUtil.getNameHint(processor))) {
            GrLightMethodBuilder m = new GrLightMethodBuilder(aClass.getManager(), "get_");
            m.setReturnType(null);
            if (!processor.execute((PsiElement)m, state)) {
                return;
            }
        }
    }

    @Override
    public String getParentClassName() {
        return "spock.lang.Specification";
    }
}

