/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.spock;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class SpockVariableDescriptor {
    private final String myName;
    private final PsiElement myNavigationElement;
    private final List<GrExpression> myExpressions;
    private List<GrExpression> myExpressionsOfCollection;
    private PsiVariable myVariable;

    public SpockVariableDescriptor(PsiElement navigationElement, String name) {
        this.myName = name;
        this.myNavigationElement = navigationElement;
        this.myExpressions = new ArrayList<GrExpression>();
    }

    public SpockVariableDescriptor addExpression(GrExpression expression) {
        this.myExpressions.add(expression);
        return this;
    }

    public SpockVariableDescriptor addExpressionOfCollection(GrExpression expression) {
        if (this.myExpressionsOfCollection == null) {
            this.myExpressionsOfCollection = new ArrayList<GrExpression>();
        }
        this.myExpressionsOfCollection.add(expression);
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getNavigationElement() {
        return this.myNavigationElement;
    }

    public PsiVariable getVariable() {
        if (this.myVariable == null) {
            final PsiManager manager = this.myNavigationElement.getManager();
            PsiType type = (PsiType)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, (Computable)new Computable<PsiType>(){

                public PsiType compute() {
                    PsiType res = null;
                    for (GrExpression expression : SpockVariableDescriptor.this.myExpressions) {
                        if (expression == null) continue;
                        res = TypesUtil.getLeastUpperBoundNullable(res, expression.getType(), manager);
                    }
                    if (SpockVariableDescriptor.this.myExpressionsOfCollection != null) {
                        for (GrExpression expression : SpockVariableDescriptor.this.myExpressionsOfCollection) {
                            if (expression == null) continue;
                            PsiType listType = expression.getType();
                            PsiType type = PsiUtil.extractIterableTypeParameter((PsiType)listType, (boolean)true);
                            if (type == null) {
                                if (listType == null) continue;
                                if (listType.equalsToText("java.lang.String")) {
                                    type = PsiType.getJavaLangString((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
                                }
                            }
                            res = TypesUtil.getLeastUpperBoundNullable(res, type, manager);
                        }
                    }
                    return res;
                }
            });
            if (type == null) {
                type = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)this.myNavigationElement.getResolveScope());
            }
            this.myVariable = new SpockVariable(manager, this.myName, type, this.myNavigationElement);
        }
        return this.myVariable;
    }

    public String toString() {
        return this.myName;
    }

    private static class SpockVariable
    extends GrLightVariable {
        public SpockVariable(PsiManager manager, @NonNls String name, PsiType type, PsiElement navigationElement) {
            super(manager, name, type, navigationElement);
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return super.isEquivalentTo(another) || another instanceof SpockVariable && this.getNavigationElement() == another.getNavigationElement();
        }
    }
}

