/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template.expressions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class ParameterNameExpression
extends Expression {
    private final String myDefaultName;

    public ParameterNameExpression(String name) {
        this.myDefaultName = name;
    }

    public Result calculateResult(ExpressionContext context) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        SuggestedNameInfo info = this.getNameInfo(context);
        if (info == null) {
            return new TextResult("p");
        }
        String[] names = info.names;
        if (names.length > 0) {
            return new TextResult(names[0]);
        }
        return null;
    }

    private SuggestedNameInfo getNameInfo(ExpressionContext context) {
        Project project = context.getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        assert (file != null);
        PsiElement elementAt = file.findElementAt(context.getStartOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)elementAt, GrParameter.class);
        if (parameter == null) {
            return null;
        }
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project);
        return manager.suggestVariableName(VariableKind.PARAMETER, this.myDefaultName, null, parameter.getTypeGroovy());
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        SuggestedNameInfo info = this.getNameInfo(context);
        if (info == null) {
            return null;
        }
        LookupElement[] result = new LookupElement[info.names.length];
        int i = 0;
        for (String name : info.names) {
            result[i++] = LookupElementBuilder.create((String)name);
        }
        return result;
    }
}

