/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyTryUnwrapper
extends GroovyUnwrapper {
    public GroovyTryUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.try", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(PsiElement e) {
        return e instanceof GrTryCatchStatement;
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        GrTryCatchStatement trySt = (GrTryCatchStatement)element;
        context.extractFromCodeBlock(trySt.getTryBlock(), trySt);
        GrFinallyClause finallyClause = trySt.getFinallyClause();
        if (finallyClause != null) {
            context.extractFromCodeBlock(finallyClause.getBody(), trySt);
        }
        context.delete(trySt);
    }
}

