/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util.dynamicMembers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.util.dynamicMembers.GrDynamicMethodImpl;
import org.jetbrains.plugins.groovy.util.dynamicMembers.GrDynamicPropertyImpl;

public class DynamicMemberUtils {
    public static final Key<Map<String, String>> COMMENT_KEY = Key.create((String)"DynamicMemberUtils:COMMENT_KEY");
    private static final Key<ConcurrentHashMap<String, ClassMemberHolder>> KEY = Key.create((String)"DynamicMemberUtils");

    private DynamicMemberUtils() {
    }

    public static ClassMemberHolder getMembers(Project project, String source) {
        ClassMemberHolder oldValue;
        ClassMemberHolder res;
        ConcurrentHashMap map = (ConcurrentHashMap)project.getUserData(KEY);
        if (map == null) {
            map = new ConcurrentHashMap();
            map = (ConcurrentHashMap)((UserDataHolderEx)project).putUserDataIfAbsent(KEY, map);
        }
        if ((res = (ClassMemberHolder)map.get(source)) == null && (oldValue = map.putIfAbsent(source, res = new ClassMemberHolder(project, source))) != null) {
            res = oldValue;
        }
        assert (source == res.myClassSource) : "Store class sources in static constant, do not generate it in each call.";
        return res;
    }

    public static boolean process(PsiScopeProcessor processor, PsiClass psiClass, GrReferenceExpression ref, String classSource) {
        return DynamicMemberUtils.process(processor, GrStaticChecker.isInStaticContext(ref, psiClass), (PsiElement)ref, classSource);
    }

    public static boolean process(PsiScopeProcessor processor, boolean isInStaticContext, PsiElement place, String classSource) {
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        String name = ResolveUtil.getNameHint(processor);
        ClassMemberHolder memberHolder = DynamicMemberUtils.getMembers(place.getProject(), classSource);
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.METHOD)) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = isInStaticContext ? memberHolder.getStaticMethods(name) : memberHolder.getMethods(name)) {
                if (processor.execute((PsiElement)psiMethod, ResolveState.initial())) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            PsiField[] fields = isInStaticContext ? memberHolder.getStaticFields(name) : memberHolder.getFields(name);
            for (PsiMethod psiMethod : fields) {
                if (processor.execute((PsiElement)psiMethod, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkVersion(PsiMethod method, String version) {
        String since = DynamicMemberUtils.getCommentValue(method, "since");
        if (since == null) {
            return true;
        }
        return version.compareTo(since) >= 0;
    }

    public static String getCommentValue(PsiMethod method, String commentTagName) {
        Map commentMap = (Map)method.getUserData(COMMENT_KEY);
        if (commentMap == null) {
            return null;
        }
        return (String)commentMap.get(commentTagName);
    }

    public static boolean isDynamicElement(PsiElement element) {
        return element instanceof DynamicElement;
    }

    public static boolean isDynamicElement(PsiElement element, String classSource) {
        return element instanceof DynamicElement && classSource.equals(((DynamicElement)element).getSource());
    }

    private static class MyGrDynamicPropertyImpl
    extends GrDynamicPropertyImpl
    implements DynamicElement,
    OriginInfoAwareElement {
        private final String mySource;
        private final PsiClass myClass;
        private String myOriginalInfo;

        private MyGrDynamicPropertyImpl(PsiClass containingClass, GrField field, PsiElement navigationalElement, String source) {
            super(null, field, navigationalElement);
            this.myClass = containingClass;
            this.mySource = source;
        }

        @Override
        public String getSource() {
            return this.mySource;
        }

        @Override
        public PsiClass getSourceClass() {
            return this.myClass;
        }

        public String getOriginInfo() {
            return this.myOriginalInfo;
        }

        public void setOriginalInfo(String originalInfo) {
            this.myOriginalInfo = originalInfo;
        }
    }

    private static class GrDynamicMethodWithCache
    extends GrDynamicMethodImpl
    implements DynamicElement,
    OriginInfoAwareElement {
        private final PsiTypeParameter[] myTypeParameters = super.getTypeParameters();
        private final GrParameterList myParameterList = super.getParameterList();
        private final Map<String, NamedArgumentDescriptor> namedParameters = super.getNamedParameters();
        private String myOriginalInfo;
        public final String mySource;

        public GrDynamicMethodWithCache(GrMethod method, String source) {
            super(method);
            this.mySource = source;
        }

        public String getText() {
            return this.myMethod.getText();
        }

        @Override
        public PsiTypeParameter[] getTypeParameters() {
            return this.myTypeParameters;
        }

        @Override
        public GrParameterList getParameterList() {
            return this.myParameterList;
        }

        @Override
        public Map<String, NamedArgumentDescriptor> getNamedParameters() {
            return this.namedParameters;
        }

        public Icon getIcon(int flags) {
            return this.myMethod.getIcon(flags);
        }

        @Override
        public String getSource() {
            return this.mySource;
        }

        @Override
        public PsiClass getSourceClass() {
            return this.myMethod.getContainingClass();
        }

        public String getOriginInfo() {
            return this.myOriginalInfo;
        }

        public void setOriginalInfo(String originalInfo) {
            this.myOriginalInfo = originalInfo;
        }
    }

    public static interface DynamicElement {
        public String getSource();

        public PsiClass getSourceClass();
    }

    public static class ClassMemberHolder {
        private final String myClassSource;
        private final GrTypeDefinition myClass;
        private final Map<String, PsiMethod[]> myMethodMap;
        private final Map<String, PsiField[]> myFieldMap;
        private final Map<String, PsiMethod[]> myStaticMethodMap;
        private final Map<String, PsiField[]> myStaticFieldMap;
        private final Map<String, PsiMethod[]> myNonStaticMethodMap;
        private final Map<String, PsiField[]> myNonStaticFieldMap;

        private ClassMemberHolder(Project project, String classSource) {
            this.myClassSource = classSource;
            GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
            this.myClass = (GrTypeDefinition)elementFactory.createGroovyFile(classSource, false, null).getClasses()[0];
            Map<String, String> classCommentMap = ClassMemberHolder.parseComment(this.myClass.getDocComment());
            this.myFieldMap = new HashMap<String, PsiField[]>();
            this.myStaticFieldMap = new HashMap<String, PsiField[]>();
            this.myNonStaticFieldMap = new HashMap<String, PsiField[]>();
            GrField[] fields = this.myClass.getFields();
            PsiField[] allFields = new PsiField[fields.length];
            int i = 0;
            for (GrField field : fields) {
                MyGrDynamicPropertyImpl dynamicField = new MyGrDynamicPropertyImpl(this.myClass, field, null, classSource);
                Map<String, String> commentMap = ClassMemberHolder.parseComment(field.getDocComment());
                String originalInfo = commentMap.get("originalInfo");
                if (originalInfo == null) {
                    originalInfo = classCommentMap.get("originalInfo");
                }
                dynamicField.setOriginalInfo(originalInfo);
                PsiField[] dynamicFieldArray = new PsiField[]{dynamicField};
                if (field.hasModifierProperty("static")) {
                    this.myStaticFieldMap.put(field.getName(), dynamicFieldArray);
                } else {
                    this.myNonStaticFieldMap.put(field.getName(), dynamicFieldArray);
                }
                PsiField[] oldValue = this.myFieldMap.put(field.getName(), dynamicFieldArray);
                assert (oldValue == null) : "Duplicated field in dynamic class: " + this.myClass.getName() + ":" + field.getName();
                allFields[i++] = dynamicField;
            }
            this.myFieldMap.put(null, allFields);
            ClassMemberHolder.checkDuplicatedMethods(this.myClass);
            MultiMap multiMap = new MultiMap();
            MultiMap staticMultiMap = new MultiMap();
            MultiMap nonStaticMultiMap = new MultiMap();
            for (GrMethod method : this.myClass.getCodeMethods()) {
                String originalInfo;
                GrDynamicMethodWithCache dynamicMethod = new GrDynamicMethodWithCache(method, classSource);
                Map<String, String> commentMap = ClassMemberHolder.parseComment(method.getDocComment());
                if (!commentMap.isEmpty()) {
                    dynamicMethod.putUserData(COMMENT_KEY, commentMap);
                }
                if ((originalInfo = commentMap.get("originalInfo")) == null) {
                    originalInfo = classCommentMap.get("originalInfo");
                }
                dynamicMethod.setOriginalInfo(originalInfo);
                String kind = commentMap.get("kind");
                if (kind == null) {
                    kind = classCommentMap.get("kind");
                }
                if (kind != null) {
                    dynamicMethod.putUserData(GrLightMethodBuilder.KIND_KEY, kind);
                }
                multiMap.putValue(null, (Object)dynamicMethod);
                multiMap.putValue((Object)method.getName(), (Object)dynamicMethod);
                if (method.hasModifierProperty("static")) {
                    staticMultiMap.putValue(null, (Object)dynamicMethod);
                    staticMultiMap.putValue((Object)method.getName(), (Object)dynamicMethod);
                    continue;
                }
                nonStaticMultiMap.putValue(null, (Object)dynamicMethod);
                nonStaticMultiMap.putValue((Object)method.getName(), (Object)dynamicMethod);
            }
            this.myMethodMap = ClassMemberHolder.convertMap((MultiMap<String, PsiMethod>)multiMap);
            this.myStaticMethodMap = ClassMemberHolder.convertMap((MultiMap<String, PsiMethod>)staticMultiMap);
            this.myNonStaticMethodMap = ClassMemberHolder.convertMap((MultiMap<String, PsiMethod>)nonStaticMultiMap);
        }

        private static Map<String, String> parseComment(GrDocComment comment) {
            if (comment == null) {
                return Collections.emptyMap();
            }
            GrDocTag[] docTags = comment.getTags();
            if (docTags.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, String> res = new HashMap<String, String>();
            for (GrDocTag tag : docTags) {
                String tagText = tag.getText().trim();
                int idx = tagText.indexOf(32);
                if (idx == -1) continue;
                res.put(tag.getName(), tagText.substring(idx + 1).trim());
            }
            return res;
        }

        public GrTypeDefinition getParsedClass() {
            return this.myClass;
        }

        private static void checkDuplicatedMethods(PsiClass psiClass) {
            HashSet<String> existingMethods = new HashSet<String>();
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (psiMethod instanceof GrAccessorMethod || psiMethod instanceof GrReflectedMethod || existingMethods.add(psiMethod.getText())) continue;
                throw new RuntimeException("Duplicated field in dynamic class: " + psiClass.getName() + ":" + psiMethod.getText());
            }
        }

        private static Map<String, PsiMethod[]> convertMap(MultiMap<String, PsiMethod> multiMap) {
            HashMap<String, PsiMethod[]> res = new HashMap<String, PsiMethod[]>();
            for (String methodName : multiMap.keySet()) {
                Collection m = multiMap.get((Object)methodName);
                res.put(methodName, m.toArray(new PsiMethod[m.size()]));
            }
            return res;
        }

        public PsiMethod[] getMethods() {
            return this.getMethods(null);
        }

        public PsiMethod[] getDynamicMethods(String nameHint) {
            PsiMethod[] res = this.myNonStaticMethodMap.get(nameHint);
            if (res == null) {
                res = PsiMethod.EMPTY_ARRAY;
            }
            return res;
        }

        public PsiMethod[] getStaticMethods(String nameHint) {
            PsiMethod[] res = this.myStaticMethodMap.get(nameHint);
            if (res == null) {
                res = PsiMethod.EMPTY_ARRAY;
            }
            return res;
        }

        public PsiMethod[] getMethods(String nameHint) {
            PsiMethod[] res = this.myMethodMap.get(nameHint);
            if (res == null) {
                res = PsiMethod.EMPTY_ARRAY;
            }
            return res;
        }

        public PsiField[] getFields() {
            return this.getFields(null);
        }

        public PsiField[] getFields(String nameHint) {
            PsiField[] res = this.myFieldMap.get(nameHint);
            if (res == null) {
                res = PsiField.EMPTY_ARRAY;
            }
            return res;
        }

        public PsiField[] getStaticFields(String nameHint) {
            PsiField[] res = this.myStaticFieldMap.get(nameHint);
            if (res == null) {
                res = PsiField.EMPTY_ARRAY;
            }
            return res;
        }
    }
}

