/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import java.util.ArrayList;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Opcodes;
import org.jetbrains.asm4.Type;

public class NotNullVerifyingInstrumenter
extends ClassVisitor
implements Opcodes {
    private boolean myIsModification = false;
    private String myClassName;
    public static final String NOT_NULL = "org/jetbrains/annotations/NotNull";
    public static final String NOT_NULL_ANNO = "Lorg/jetbrains/annotations/NotNull;";
    public static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    public static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String CONSTRUCTOR_NAME = "<init>";

    public NotNullVerifyingInstrumenter(ClassVisitor classVisitor) {
        super(262144, classVisitor);
    }

    public boolean isModification() {
        return this.myIsModification;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
    }

    public MethodVisitor visitMethod(final int access, final String name, String desc, String signature, String[] exceptions) {
        final Type[] args = Type.getArgumentTypes((String)desc);
        final Type returnType = Type.getReturnType((String)desc);
        MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(262144, v){
            private final ArrayList myNotNullParams;
            private int mySyntheticCount;
            private boolean myIsNotNull;
            public Label myThrowLabel;
            private Label myStartGeneratedCodeLabel;
            {
                super(x0, x1);
                this.myNotNullParams = new ArrayList();
                this.mySyntheticCount = 0;
                this.myIsNotNull = false;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, anno, visible);
                if (NotNullVerifyingInstrumenter.isReferenceType(args[parameter]) && anno.equals(NotNullVerifyingInstrumenter.NOT_NULL_ANNO)) {
                    this.myNotNullParams.add(new Integer(parameter));
                } else if (anno.equals("Ljava/lang/Synthetic;")) {
                    ++this.mySyntheticCount;
                }
                return av;
            }

            public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                AnnotationVisitor av = this.mv.visitAnnotation(anno, isRuntime);
                if (NotNullVerifyingInstrumenter.isReferenceType(returnType) && anno.equals(NotNullVerifyingInstrumenter.NOT_NULL_ANNO)) {
                    this.myIsNotNull = true;
                }
                return av;
            }

            public void visitCode() {
                if (this.myNotNullParams.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                for (int p = 0; p < this.myNotNullParams.size(); ++p) {
                    int var = (access & 8) == 0 ? 1 : 0;
                    int param = (Integer)this.myNotNullParams.get(p);
                    for (int i = 0; i < param; ++i) {
                        var += args[i].getSize();
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    this.generateThrow(NotNullVerifyingInstrumenter.IAE_CLASS_NAME, "Argument " + (param - this.mySyntheticCount) + " for @NotNull parameter of " + NotNullVerifyingInstrumenter.this.myClassName + "." + name + " must not be null", end);
                }
            }

            public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
                boolean isStatic;
                boolean bl = isStatic = (access & 8) != 0;
                boolean isParameter = isStatic ? index < args.length : index <= args.length;
                this.mv.visitLocalVariable(name2, desc, signature, isParameter && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && this.myIsNotNull) {
                    this.mv.visitInsn(89);
                    if (this.myThrowLabel == null) {
                        Label skipLabel = new Label();
                        this.mv.visitJumpInsn(199, skipLabel);
                        this.myThrowLabel = new Label();
                        this.mv.visitLabel(this.myThrowLabel);
                        this.generateThrow(NotNullVerifyingInstrumenter.ISE_CLASS_NAME, "@NotNull method " + NotNullVerifyingInstrumenter.this.myClassName + "." + name + " must not return null", skipLabel);
                    } else {
                        this.mv.visitJumpInsn(198, this.myThrowLabel);
                    }
                }
                this.mv.visitInsn(opcode);
            }

            private void generateThrow(String exceptionClass, String descr, Label end) {
                String exceptionParamClass = "(Ljava/lang/String;)V";
                this.mv.visitTypeInsn(187, exceptionClass);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)descr);
                this.mv.visitMethodInsn(183, exceptionClass, NotNullVerifyingInstrumenter.CONSTRUCTOR_NAME, exceptionParamClass);
                this.mv.visitInsn(191);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                try {
                    super.visitMaxs(maxStack, maxLocals);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ArrayIndexOutOfBoundsException("maxs processing failed for method " + name + ": " + e.getMessage());
                }
            }
        };
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }
}

