/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java.ast;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.Resources;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.jvnet.ws.wadl2java.ast.MethodNode;
import org.jvnet.ws.wadl2java.ast.PathSegment;
import org.jvnet.ws.wadl2java.ast.ResourceTypeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNode {
    private ResourceNode parentResource;
    private String className;
    private PathSegment pathSegment;
    private List<ResourceNode> childResources;
    private List<MethodNode> methods;
    private List<ResourceTypeNode> types;
    private List<Doc> doc;

    public ResourceNode(Application app, Resources resources) {
        this.doc = app.getDoc();
        this.parentResource = null;
        this.className = "Endpoint";
        this.pathSegment = new PathSegment(resources == null ? "" : resources.getBase());
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode(Resource resource, ResourceNode parent) {
        this.doc = resource.getDoc();
        this.parentResource = parent;
        this.pathSegment = new PathSegment(resource);
        this.className = GeneratorUtil.makeClassName(this.pathSegment.getTemplate());
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode addChild(Resource r) {
        ResourceNode n = new ResourceNode(r, this);
        this.childResources.add(n);
        return n;
    }

    public String getClassName() {
        return this.className;
    }

    public List<ResourceNode> getChildResources() {
        return this.childResources;
    }

    public PathSegment getPathSegment() {
        return this.pathSegment;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public void addResourceType(ResourceTypeNode n) {
        this.types.add(n);
        this.methods.addAll(n.getMethods());
        this.pathSegment.getQueryParameters().addAll(n.getQueryParams());
        this.pathSegment.getMatrixParameters().addAll(n.getMatrixParams());
    }

    public List<ResourceTypeNode> getResourceTypes() {
        return this.types;
    }

    public ResourceNode getParentResource() {
        return this.parentResource;
    }

    public List<PathSegment> getPathSegments() {
        ArrayList<PathSegment> list = new ArrayList<PathSegment>();
        for (ResourceNode n = this; n != null; n = n.getParentResource()) {
            list.add(0, n.getPathSegment());
        }
        return list;
    }

    public List<Param> getQueryParams() {
        return this.getPathSegment().getQueryParameters();
    }

    public List<Param> getHeaderParams() {
        return this.getPathSegment().getHeaderParameters();
    }

    public List<Doc> getDoc() {
        return this.doc;
    }
}

