/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyArtifactSet
extends DefaultDomainObjectSet<IvyArtifact>
implements IvyArtifactSet {
    private final String publicationName;
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final ArtifactsFileCollection files = new ArtifactsFileCollection();
    private final NotationParser<Object, IvyArtifact> ivyArtifactParser;

    public DefaultIvyArtifactSet(String publicationName, NotationParser<Object, IvyArtifact> ivyArtifactParser) {
        super(IvyArtifact.class);
        this.publicationName = publicationName;
        this.ivyArtifactParser = ivyArtifactParser;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        IvyArtifact artifact = (IvyArtifact)this.ivyArtifactParser.parseNotation(source);
        this.add(artifact);
        return artifact;
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        IvyArtifact artifact = this.artifact(source);
        config.execute((Object)artifact);
        return artifact;
    }

    public FileCollection getFiles() {
        return this.files;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        public void resolve(TaskDependencyResolveContext context) {
            Iterator i$ = DefaultIvyArtifactSet.this.iterator();
            while (i$.hasNext()) {
                IvyArtifact ivyArtifact = (IvyArtifact)i$.next();
                context.add((Object)ivyArtifact);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactsFileCollection
    extends AbstractFileCollection {
        private ArtifactsFileCollection() {
        }

        public String getDisplayName() {
            return String.format("artifacts for ivy publication '%s'", DefaultIvyArtifactSet.this.publicationName);
        }

        public TaskDependency getBuildDependencies() {
            return DefaultIvyArtifactSet.this.builtBy;
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator i$ = DefaultIvyArtifactSet.this.iterator();
            while (i$.hasNext()) {
                IvyArtifact artifact = (IvyArtifact)i$.next();
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

