/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(IvyPublication.class, (NamedDomainObjectFactory)new IvyPublicationFactory(IvyPublishPlugin.this.dependencyMetaDataProvider, IvyPublishPlugin.this.instantiator, IvyPublishPlugin.this.fileResolver));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public IvyPublication create(String name) {
            ModuleInternal module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, IvyArtifact> notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            return (IvyPublication)this.instantiator.newInstance(DefaultIvyPublication.class, new Object[]{name, this.instantiator, publicationIdentity, notationParser, IvyPublishPlugin.this.projectDependencyResolver});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        public void createTasks(CollectionBuilder<Task> tasks, PublishingExtension publishingExtension, final @Path(value="buildDir") File buildDir) {
            PublicationContainer publications = publishingExtension.getPublications();
            RepositoryHandler repositories = publishingExtension.getRepositories();
            for (final IvyPublicationInternal publication : publications.withType(IvyPublicationInternal.class)) {
                final String publicationName = publication.getName();
                String descriptorTaskName = String.format("generateDescriptorFileFor%sPublication", StringUtils.capitalize((String)publicationName));
                tasks.create(descriptorTaskName, GenerateIvyDescriptor.class, (Action)new Action<GenerateIvyDescriptor>(){

                    public void execute(GenerateIvyDescriptor descriptorTask) {
                        descriptorTask.setDescription(String.format("Generates the Ivy Module Descriptor XML file for publication '%s'.", publication.getName()));
                        descriptorTask.setGroup("publishing");
                        descriptorTask.setDescriptor(publication.getDescriptor());
                        descriptorTask.setDestination(new File(buildDir, "publications/" + publication.getName() + "/ivy.xml"));
                    }
                });
                publication.setDescriptorFile(((Task)tasks.get(descriptorTaskName)).getOutputs().getFiles());
                for (final IvyArtifactRepository repository : repositories.withType(IvyArtifactRepository.class)) {
                    final String repositoryName = repository.getName();
                    String publishTaskName = String.format("publish%sPublicationTo%sRepository", StringUtils.capitalize((String)publicationName), StringUtils.capitalize((String)repositoryName));
                    tasks.create(publishTaskName, PublishToIvyRepository.class, (Action)new Action<PublishToIvyRepository>(){

                        public void execute(PublishToIvyRepository publishTask) {
                            publishTask.setPublication(publication);
                            publishTask.setRepository(repository);
                            publishTask.setGroup("publishing");
                            publishTask.setDescription(String.format("Publishes Ivy publication '%s' to Ivy repository '%s'.", publicationName, repositoryName));
                        }
                    });
                    ((Task)tasks.get("publish")).dependsOn(new Object[]{publishTaskName});
                }
            }
        }
    }
}

