/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import junit.framework.ComparisonFailure;

public class ComparisonFailureData {
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private static Map EXPECTED = new HashMap();
    private static Map ACTUAL = new HashMap();
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;
    static /* synthetic */ Class class$org$junit$ComparisonFailure;

    private static void init(Class exceptionClass) throws NoSuchFieldException {
        Field expectedField = exceptionClass.getDeclaredField("fExpected");
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField("fActual");
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonFailureData(String expected, String actual) {
        this(expected, actual, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public static ComparisonFailureData create(Throwable assertion) {
        if (assertion instanceof FileComparisonFailure) {
            FileComparisonFailure comparisonFailure = (FileComparisonFailure)((Object)assertion);
            return new ComparisonFailureData(comparisonFailure.getExpected(), comparisonFailure.getActual(), comparisonFailure.getFilePath());
        }
        try {
            return new ComparisonFailureData(ComparisonFailureData.getExpected(assertion), ComparisonFailureData.getActual(assertion));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, ACTUAL, "fActual");
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, EXPECTED, "fExpected");
    }

    private static String get(Throwable assertion, Map staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        String actual;
        if (assertion instanceof ComparisonFailure) {
            actual = (String)((Field)staticMap.get(class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = ComparisonFailureData.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure)).get(assertion);
        } else if (assertion instanceof org.junit.ComparisonFailure) {
            actual = (String)((Field)staticMap.get(class$org$junit$ComparisonFailure == null ? (class$org$junit$ComparisonFailure = ComparisonFailureData.class$("org.junit.ComparisonFailure")) : class$org$junit$ComparisonFailure)).get(assertion);
        } else {
            Field field = assertion.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            actual = (String)field.get(assertion);
        }
        return actual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ComparisonFailureData.init(class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = ComparisonFailureData.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure);
            ComparisonFailureData.init(class$org$junit$ComparisonFailure == null ? (class$org$junit$ComparisonFailure = ComparisonFailureData.class$("org.junit.ComparisonFailure")) : class$org$junit$ComparisonFailure);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

