/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.internal.AbstractPolymorphicDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolymorphicDomainObjectContainer<T>
extends AbstractPolymorphicDomainObjectContainer<T>
implements ExtensiblePolymorphicDomainObjectContainer<T> {
    protected final Map<Class<? extends T>, NamedDomainObjectFactory<? extends T>> factories = Maps.newHashMap();

    public DefaultPolymorphicDomainObjectContainer(Class<? extends T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    public DefaultPolymorphicDomainObjectContainer(Class<? extends T> type, Instantiator instantiator) {
        this(type, instantiator, Named.Namer.forType(type));
    }

    @Override
    protected T doCreate(String name) {
        NamedDomainObjectFactory<T> factory = this.factories.get(this.getType());
        if (factory == null) {
            throw new InvalidUserDataException(String.format("Cannot create a %s named '%s' because this container does not support creating elements by name alone. Please specify which subtype of %s to create. Known subtypes are: %s", this.getTypeDisplayName(), name, this.getTypeDisplayName(), this.getSupportedTypeNames()));
        }
        return factory.create(name);
    }

    @Override
    protected <U extends T> U doCreate(String name, Class<U> type) {
        NamedDomainObjectFactory<T> factory = this.factories.get(type);
        if (factory == null) {
            throw new InvalidUserDataException(String.format("Cannot create a %s because this type is not known to this container. Known types are: %s", type.getSimpleName(), this.getSupportedTypeNames()));
        }
        return (U)factory.create(name);
    }

    @Override
    public <U extends T> void registerDefaultFactory(NamedDomainObjectFactory<U> factory) {
        this.factories.put(this.getType(), factory);
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        if (!this.getType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Cannot register a factory for type %s because it is not a subtype of container element type %s.", type.getSimpleName(), this.getTypeDisplayName()));
        }
        if (this.factories.containsKey(type)) {
            throw new GradleException(String.format("Cannot register a factory for type %s because a factory for this type is already registered.", type.getSimpleName()));
        }
        this.factories.put(type, factory);
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, final Closure<? extends U> factory) {
        this.registerFactory(type, new NamedDomainObjectFactory<U>(){

            @Override
            public U create(String name) {
                return factory.call((Object)name);
            }
        });
    }

    @Override
    public <U extends T> void registerBinding(Class<U> type, final Class<? extends U> implementationType) {
        this.registerFactory(type, new NamedDomainObjectFactory<U>(){
            boolean named;
            {
                this.named = Named.class.isAssignableFrom(implementationType);
            }

            @Override
            public U create(String name) {
                return this.named ? DefaultPolymorphicDomainObjectContainer.this.getInstantiator().newInstance(implementationType, new Object[]{name}) : DefaultPolymorphicDomainObjectContainer.this.getInstantiator().newInstance(implementationType, new Object[0]);
            }
        });
    }

    private String getSupportedTypeNames() {
        ArrayList names = Lists.newArrayList();
        for (Class<T> clazz : this.factories.keySet()) {
            names.add(clazz.getSimpleName());
        }
        Collections.sort(names);
        return names.isEmpty() ? "(None)" : Joiner.on((String)", ").join((Iterable)names);
    }

    @Override
    public Set<? extends Class<? extends T>> getCreateableTypes() {
        return ImmutableSet.copyOf(this.factories.keySet());
    }
}

