/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Transformers;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private Map<String, Runnable> placeholders = new HashMap<String, Runnable>();

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener) {
        super(Task.class, instantiator, project);
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
    }

    @Override
    public Task create(Map<String, ?> options) {
        HashMap mutableOptions = new HashMap(options);
        Object replaceStr = mutableOptions.remove("overwrite");
        boolean replace = replaceStr != null && "true".equals(replaceStr.toString());
        TaskInternal task = this.taskFactory.createTask(mutableOptions);
        String name = task.getName();
        Task existing = (Task)this.findByNameWithoutRules(name);
        if (existing != null) {
            if (replace) {
                this.remove(existing);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
            }
        }
        this.add(task);
        return task;
    }

    @Override
    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return (U)this.create(name, (Class)type);
    }

    @Override
    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map("name", name, "type", type))));
    }

    @Override
    public Task create(String name) {
        return this.create(GUtil.map("name", name));
    }

    @Override
    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    @Override
    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    @Override
    public Task replace(String name) {
        return this.create(GUtil.map("name", name, "overwrite", true));
    }

    @Override
    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        Object task = this.create(name, (Class)type);
        configuration.execute(task);
        return (T)task;
    }

    @Override
    public <T extends Task> T replace(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map("name", name, "type", type, "overwrite", true))));
    }

    @Override
    public Task findByPath(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(!GUtil.isTrue(projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path);
    }

    @Override
    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, new NamedDomainObjectContainerConfigureDelegate(configureClosure.getOwner(), this));
        return this;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        TreeSet<String> set = new TreeSet<String>();
        for (Task o : this.getStore()) {
            set.add(o.getName());
        }
        for (String placeHolderName : this.placeholders.keySet()) {
            set.add(placeHolderName);
        }
        return set;
    }

    @Override
    public void actualize() {
        new CachingDirectedGraphWalker<Task, Void>(new DirectedGraph<Task, Void>(){

            @Override
            public void getNodeValues(Task node, Collection<? super Void> values, Collection<? super Task> connectedNodes) {
                connectedNodes.addAll(node.getTaskDependencies().getDependencies(node));
            }
        }).add(this).findValues();
        HashSet<String> placeholderNames = new HashSet<String>(this.placeholders.keySet());
        for (String placeholder : placeholderNames) {
            this.maybeMaterializePlaceholder(placeholder);
        }
    }

    @Override
    public Map<String, Runnable> getPlaceholderActions() {
        return this.placeholders;
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        this.maybeMaterializePlaceholder(name);
        return (Task)super.findByName(name);
    }

    private void maybeMaterializePlaceholder(String name) {
        if (this.placeholders.containsKey(name) && super.findByName(name) == null) {
            Runnable placeholderAction = this.placeholders.remove(name);
            placeholderAction.run();
        }
    }

    @Override
    public void addPlaceholderAction(String placeholderName, Runnable runnable) {
        this.placeholders.put(placeholderName, runnable);
    }

    @Override
    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }
}

