/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExecuteAtMostOnceTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ExecuteAtMostOnceTaskExecuter.class);
    private final TaskExecuter executer;

    public ExecuteAtMostOnceTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (state.getExecuted()) {
            return;
        }
        LOGGER.debug("Starting to execute {}", task);
        try {
            this.executer.execute(task, state, context);
        }
        finally {
            state.executed();
            LOGGER.debug("Finished executing {}", task);
        }
    }
}

