/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import org.codehaus.groovy.classgen.Verifier;
import org.gradle.api.Action;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.hash.HashUtil;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheBackedScriptClassCompiler
implements ScriptClassCompiler,
Closeable {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private ProgressLoggerFactory progressLoggerFactory;
    private final CacheRepository cacheRepository;
    private final CacheValidator validator;
    private final CompositeStoppable caches = new CompositeStoppable();

    public FileCacheBackedScriptClassCompiler(CacheRepository cacheRepository, CacheValidator validator, ScriptCompilationHandler scriptCompilationHandler, ProgressLoggerFactory progressLoggerFactory) {
        this.cacheRepository = cacheRepository;
        this.validator = validator;
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public <T extends Script> Class<? extends T> compile(ScriptSource source, ClassLoader classLoader, Transformer transformer, Class<T> scriptBaseClass, Verifier verifier) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("source.filename", source.getFileName());
        properties.put("source.hash", HashUtil.createCompactMD5((String)source.getResource().getText()));
        String cacheName = String.format("scripts/%s/%s/%s", source.getClassName(), scriptBaseClass.getSimpleName(), transformer.getId());
        PersistentCache cache = this.cacheRepository.cache(cacheName).withProperties(properties).withValidator(this.validator).withDisplayName(String.format("%s class cache for %s", transformer.getId(), source.getDisplayName())).withInitializer(new ProgressReportingInitializer(this.progressLoggerFactory, new CacheInitializer(source, classLoader, transformer, verifier, scriptBaseClass))).open();
        this.caches.add(new Object[]{cache});
        File classesDir = this.classesDir(cache);
        return this.scriptCompilationHandler.loadFromDir(source, classLoader, classesDir, scriptBaseClass);
    }

    @Override
    public void close() {
        this.caches.stop();
    }

    private File classesDir(PersistentCache cache) {
        return new File(cache.getBaseDir(), "classes");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProgressReportingInitializer
    implements Action<PersistentCache> {
        private ProgressLoggerFactory progressLoggerFactory;
        private Action<? super PersistentCache> delegate;

        public ProgressReportingInitializer(ProgressLoggerFactory progressLoggerFactory, Action<PersistentCache> delegate) {
            this.progressLoggerFactory = progressLoggerFactory;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(PersistentCache cache) {
            ProgressLogger op = this.progressLoggerFactory.newOperation(FileCacheBackedScriptClassCompiler.class).start("Compile script into cache", "Compiling script into cache");
            try {
                this.delegate.execute((Object)cache);
            }
            finally {
                op.completed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheInitializer
    implements Action<PersistentCache> {
        private final Verifier verifier;
        private final Class<? extends Script> scriptBaseClass;
        private final ClassLoader classLoader;
        private final Transformer transformer;
        private final ScriptSource source;

        private CacheInitializer(ScriptSource source, ClassLoader classLoader, Transformer transformer, Verifier verifier, Class<? extends Script> scriptBaseClass) {
            this.source = source;
            this.classLoader = classLoader;
            this.transformer = transformer;
            this.verifier = verifier;
            this.scriptBaseClass = scriptBaseClass;
        }

        public void execute(PersistentCache cache) {
            File classesDir = FileCacheBackedScriptClassCompiler.this.classesDir(cache);
            FileCacheBackedScriptClassCompiler.this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, classesDir, this.transformer, this.scriptBaseClass, this.verifier);
        }
    }
}

