/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging;

import org.gradle.api.Action;
import org.gradle.cli.CommandLineConverter;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.ConsoleConfigureAction;
import org.gradle.logging.internal.DefaultLoggingConfigurer;
import org.gradle.logging.internal.DefaultLoggingManagerFactory;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.DefaultStdErrLoggingSystem;
import org.gradle.logging.internal.DefaultStdOutLoggingSystem;
import org.gradle.logging.internal.DefaultStyledTextOutputFactory;
import org.gradle.logging.internal.JavaUtilLoggingConfigurer;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.logging.internal.NoOpLoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.logging.internal.ProgressLoggingBridge;
import org.gradle.logging.internal.TextStreamOutputEventListener;
import org.gradle.logging.internal.logback.LogbackLoggingConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggingServiceRegistry
extends DefaultServiceRegistry {
    private TextStreamOutputEventListener stdoutListener;

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        return new CommandLineLogging();
    }

    public static LoggingServiceRegistry newProcessLogging() {
        return new ChildProcessLogging();
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new EmbeddedLogging();
    }

    public LoggingServiceRegistry newLogging() {
        return new NestedLogging();
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected TimeProvider createTimeProvider() {
        return new TrueTimeProvider();
    }

    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
    }

    protected TextStreamOutputEventListener getStdoutListener() {
        if (this.stdoutListener == null) {
            this.stdoutListener = new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class));
        }
        return this.stdoutListener;
    }

    protected ProgressLoggerFactory createProgressLoggerFactory() {
        return new DefaultProgressLoggerFactory(new ProgressLoggingBridge((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
    }

    protected abstract Factory<LoggingManagerInternal> createLoggingManagerFactory();

    protected OutputEventRenderer createOutputEventRenderer() {
        OutputEventRenderer renderer = new OutputEventRenderer((Action<? super OutputEventRenderer>)Actions.doNothing());
        renderer.addStandardOutputAndError();
        return renderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedLogging
    extends LoggingServiceRegistry {
        private NestedLogging() {
        }

        @Override
        protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            return new DefaultLoggingManagerFactory(renderer, renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmbeddedLogging
    extends LoggingServiceRegistry {
        private EmbeddedLogging() {
        }

        @Override
        protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            return new DefaultLoggingManagerFactory(new DefaultLoggingConfigurer(renderer, new LogbackLoggingConfigurer(renderer)), renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    private static class CommandLineLogging
    extends ChildProcessLogging {
        private CommandLineLogging() {
        }

        protected OutputEventRenderer createOutputEventRenderer() {
            OutputEventRenderer renderer = new OutputEventRenderer(new ConsoleConfigureAction());
            renderer.addStandardOutputAndError();
            return renderer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildProcessLogging
    extends LoggingServiceRegistry {
        private ChildProcessLogging() {
        }

        @Override
        protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            DefaultStdOutLoggingSystem stdout = new DefaultStdOutLoggingSystem(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
            DefaultStdErrLoggingSystem stderr = new DefaultStdErrLoggingSystem(new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
            return new DefaultLoggingManagerFactory(new DefaultLoggingConfigurer(renderer, new LogbackLoggingConfigurer(renderer), new JavaUtilLoggingConfigurer()), renderer, stdout, stderr);
        }
    }
}

