/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.collection.CollectionBuilderModelView;
import org.gradle.model.collection.internal.DefaultCollectionBuilder;
import org.gradle.model.entity.internal.NamedEntityInstantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicDomainObjectContainerModelProjection<C extends PolymorphicDomainObjectContainerInternal<M>, M>
implements ModelProjection<C> {
    private final C container;
    private final Class<M> itemType;

    public PolymorphicDomainObjectContainerModelProjection(C container, Class<M> itemType) {
        this.container = container;
        this.itemType = itemType;
    }

    public <T> boolean canBeViewedAsWritable(ModelType<T> targetType) {
        if (targetType.getRawClass().equals(CollectionBuilder.class)) {
            ModelType targetItemType = (ModelType)targetType.getTypeVariables().get(0);
            return targetItemType.getRawClass().isAssignableFrom(this.itemType) || this.itemType.isAssignableFrom(targetItemType.getRawClass());
        }
        return false;
    }

    public <T> boolean canBeViewedAsReadOnly(ModelType<T> type) {
        return false;
    }

    public <T> ModelView<? extends T> asWritable(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar, C instance) {
        ModelType targetType = binding.getReference().getType();
        if (this.canBeViewedAsWritable(targetType)) {
            ModelType targetItemType = (ModelType)targetType.getTypeVariables().get(0);
            if (targetItemType.getRawClass().isAssignableFrom(this.itemType)) {
                return this.toView(binding, sourceDescriptor, inputs, modelRuleRegistrar, this.itemType);
            }
            Class<M> subType = targetItemType.getRawClass().asSubclass(this.itemType);
            return this.toView(binding, sourceDescriptor, inputs, modelRuleRegistrar, subType);
        }
        return null;
    }

    private <T, S extends M> ModelView<? extends T> toView(ModelBinding<T> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRuleRegistrar, Class<S> itemType) {
        CollectionBuilderModelView view;
        DefaultCollectionBuilder builder = new DefaultCollectionBuilder(binding.getPath(), new Instantiator<S>(itemType, this.container), sourceDescriptor, inputs, modelRuleRegistrar);
        ModelType viewType = new ModelType.Builder<CollectionBuilder<S>>(){}.where(new ModelType.Parameter<S>(){}, ModelType.of(itemType)).build();
        CollectionBuilderModelView cast = view = new CollectionBuilderModelView(viewType, (CollectionBuilder)builder, binding.getPath(), sourceDescriptor);
        return cast;
    }

    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, C instance) {
        return null;
    }

    public Iterable<String> getWritableTypeDescriptions() {
        return Collections.singleton(PolymorphicDomainObjectContainerModelProjection.getBuilderTypeDescriptionForCreatableTypes(this.container.getCreateableTypes()));
    }

    public Iterable<String> getReadableTypeDescriptions() {
        return Collections.emptySet();
    }

    public static String getBuilderTypeDescriptionForCreatableTypes(Collection<? extends Class<?>> createableTypes) {
        StringBuilder sb = new StringBuilder(CollectionBuilder.class.getName());
        if (createableTypes.size() == 1) {
            String onlyType = ((Class)Iterables.getFirst(createableTypes, null)).getName();
            sb.append("<").append(onlyType).append(">");
        } else {
            sb.append("<T>; where T is one of [");
            Joiner.on((String)", ").appendTo(sb, (Iterable)CollectionUtils.sort((Iterable)Iterables.transform(createableTypes, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Instantiator<I>
    implements NamedEntityInstantiator<I> {
        private final Class<I> defaultType;
        private final ModelType<I> itemType;
        private final PolymorphicDomainObjectContainer<? super I> container;

        Instantiator(Class<I> defaultType, PolymorphicDomainObjectContainer<? super I> container) {
            this.defaultType = defaultType;
            this.itemType = ModelType.of(defaultType);
            this.container = container;
        }

        public ModelType<I> getType() {
            return this.itemType;
        }

        public I create(String name) {
            return this.container.create(name, this.defaultType);
        }

        public <S extends I> S create(String name, Class<S> type) {
            return this.container.create(name, type);
        }
    }
}

