/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.foundation.ProjectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConverter {
    private List<ProjectView> rootLevelResultingProjects = new ArrayList<ProjectView>();
    private final ProjectTaskLister taskLister;

    public ProjectConverter(ProjectTaskLister taskLister) {
        this.taskLister = taskLister;
    }

    public List<ProjectView> convertProjects(Project rootProject) {
        this.rootLevelResultingProjects.clear();
        this.addRootLevelProject(rootProject);
        return this.rootLevelResultingProjects;
    }

    public void addRootLevelProject(Project rootLevelProject) {
        ProjectView rootLevelProjectView = new ProjectView(null, rootLevelProject.getName(), rootLevelProject.getBuildFile(), rootLevelProject.getDescription());
        this.rootLevelResultingProjects.add(rootLevelProjectView);
        this.addSubProjects(rootLevelProject, rootLevelProjectView);
        this.addTasks(rootLevelProject, rootLevelProjectView);
        rootLevelProjectView.sortSubProjectsAndTasks();
    }

    private void addSubProjects(Project parentProject, ProjectView parentProjectView) {
        Collection subProjects = parentProject.getChildProjects().values();
        for (Project subProject : subProjects) {
            ProjectView projectView = new ProjectView(parentProjectView, subProject.getName(), subProject.getBuildFile(), subProject.getDescription());
            this.addTasks(subProject, projectView);
            projectView.sortSubProjectsAndTasks();
            this.addSubProjects(subProject, projectView);
        }
    }

    private void addTasks(Project project, ProjectView projectView) {
        List defaultTasks = project.getDefaultTasks();
        for (Task task : this.taskLister.listProjectTasks(project)) {
            String taskName = task.getName();
            boolean isDefault = defaultTasks.contains(taskName);
            projectView.createTask(taskName, task.getDescription(), isDefault);
        }
    }
}

