/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.CommandLineAssistant;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.foundation.ipc.basic.ProcessLauncherServer;
import org.gradle.foundation.queue.ExecutionQueue;
import org.gradle.gradleplugin.foundation.CommandLineArgumentAlteringListener;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.foundation.request.ExecutionRequest;
import org.gradle.gradleplugin.foundation.request.RefreshTaskListRequest;
import org.gradle.gradleplugin.foundation.request.Request;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.logging.ShowStacktrace;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradlePluginLord {
    private final Logger logger = Logging.getLogger(GradlePluginLord.class);
    private File gradleHomeDirectory;
    private File currentDirectory;
    private File customGradleExecutor;
    private List<ProjectView> projects = new ArrayList<ProjectView>();
    private FavoritesEditor favoritesEditor;
    private QueueManager queueManager = new QueueManager();
    private ShowStacktrace stackTraceLevel = ShowStacktrace.INTERNAL_EXCEPTIONS;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private ObserverLord<GeneralPluginObserver> generalObserverLord = new ObserverLord();
    private ObserverLord<RequestObserver> requestObserverLord = new ObserverLord();
    private ObserverLord<SettingsObserver> settingsObserverLord = new ObserverLord();
    private ObserverLord<CommandLineArgumentAlteringListener> commandLineArgumentObserverLord = new ObserverLord();
    private long nextRequestID = 1L;

    public List<ProjectView> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    public void setProjects(final List<ProjectView> newProjects) {
        this.projects.clear();
        if (newProjects != null) {
            this.projects.addAll(newProjects);
        }
        this.generalObserverLord.notifyObservers(new ObserverLord.ObserverNotification<GeneralPluginObserver>(){

            @Override
            public void notify(GeneralPluginObserver observer) {
                observer.projectsAndTasksReloaded(newProjects != null);
            }
        });
    }

    public GradlePluginLord() {
        this.favoritesEditor = new FavoritesEditor();
        this.currentDirectory = SystemProperties.getInstance().getCurrentDir();
        String gradleHomeProperty = System.getProperty("gradle.home");
        this.gradleHomeDirectory = gradleHomeProperty != null ? new File(gradleHomeProperty) : new DefaultModuleRegistry().getGradleHome();
    }

    public File getGradleHomeDirectory() {
        if (this.gradleHomeDirectory == null || !this.gradleHomeDirectory.isDirectory()) {
            throw new IllegalArgumentException("Could not locate Gradle home directory.");
        }
        return this.gradleHomeDirectory;
    }

    public void setGradleHomeDirectory(File gradleHomeDirectory) {
        if (this.areEqual(this.gradleHomeDirectory, gradleHomeDirectory)) {
            return;
        }
        this.gradleHomeDirectory = gradleHomeDirectory;
        this.notifySettingsChanged();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public boolean setCurrentDirectory(File currentDirectory) {
        if (this.areEqual(this.currentDirectory, currentDirectory)) {
            return false;
        }
        this.currentDirectory = currentDirectory;
        this.notifySettingsChanged();
        return true;
    }

    public File getCustomGradleExecutor() {
        return this.customGradleExecutor;
    }

    public boolean setCustomGradleExecutor(File customGradleExecutor) {
        if (this.areEqual(this.customGradleExecutor, customGradleExecutor)) {
            return false;
        }
        this.customGradleExecutor = customGradleExecutor;
        this.notifySettingsChanged();
        return true;
    }

    public FavoritesEditor getFavoritesEditor() {
        return this.favoritesEditor;
    }

    public void setStackTraceLevel(ShowStacktrace stackTraceLevel) {
        if (this.areEqual(this.stackTraceLevel, stackTraceLevel)) {
            return;
        }
        this.stackTraceLevel = stackTraceLevel;
        this.notifySettingsChanged();
    }

    public ShowStacktrace getStackTraceLevel() {
        return this.stackTraceLevel;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return;
        }
        if (this.areEqual(this.logLevel, logLevel)) {
            return;
        }
        this.logLevel = logLevel;
        this.notifySettingsChanged();
    }

    private void notifyAboutToExecuteRequest(final Request request) {
        this.requestObserverLord.notifyObservers(new ObserverLord.ObserverNotification<RequestObserver>(){

            @Override
            public void notify(RequestObserver observer) {
                try {
                    observer.aboutToExecuteRequest(request);
                }
                catch (Exception e) {
                    GradlePluginLord.this.logger.error("notifying aboutToExecuteCommand() " + e.getMessage());
                }
            }
        });
    }

    private void notifyRequestExecutionComplete(final Request request, final int result, final String output) {
        this.requestObserverLord.notifyObservers(new ObserverLord.ObserverNotification<RequestObserver>(){

            @Override
            public void notify(RequestObserver observer) {
                try {
                    observer.requestExecutionComplete(request, result, output);
                }
                catch (Exception e) {
                    GradlePluginLord.this.logger.error("notifying requestExecutionComplete() " + e.getMessage());
                }
            }
        });
    }

    public void addGeneralPluginObserver(GeneralPluginObserver observer, boolean inEventQueue) {
        this.generalObserverLord.addObserver(observer, inEventQueue);
    }

    public void removeGeneralPluginObserver(GeneralPluginObserver observer) {
        this.generalObserverLord.removeObserver(observer);
    }

    public void addRequestObserver(RequestObserver observer, boolean inEventQueue) {
        this.requestObserverLord.addObserver(observer, inEventQueue);
    }

    public void removeRequestObserver(RequestObserver observer) {
        this.requestObserverLord.removeObserver(observer);
    }

    public void addSettingsObserver(SettingsObserver observer, boolean inEventQueue) {
        this.settingsObserverLord.addObserver(observer, inEventQueue);
    }

    public void removeSettingsObserver(SettingsObserver observer) {
        this.settingsObserverLord.removeObserver(observer);
    }

    private void notifySettingsChanged() {
        this.settingsObserverLord.notifyObservers(new ObserverLord.ObserverNotification<SettingsObserver>(){

            @Override
            public void notify(SettingsObserver observer) {
                observer.settingsChanged();
            }
        });
    }

    private boolean areEqual(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return object2 == object1;
        }
        return object1.equals(object2);
    }

    public boolean isSetupComplete() {
        return this.getCurrentDirectory() != null && this.getCurrentDirectory().exists();
    }

    public Request addExecutionRequestToQueue(String fullCommandLine, String displayName) {
        return this.addExecutionRequestToQueue(fullCommandLine, displayName, false);
    }

    public Request addExecutionRequestToQueue(TaskView task, boolean forceOutputToBeShown, String ... additionCommandLineOptions) {
        if (task == null) {
            return null;
        }
        String fullCommandLine = CommandLineAssistant.appendAdditionalCommandLineOptions(task, additionCommandLineOptions);
        return this.addExecutionRequestToQueue(fullCommandLine, task.getFullTaskName(), forceOutputToBeShown);
    }

    public Request addExecutionRequestToQueue(List<FavoriteTask> favorites) {
        String fullCommandLine;
        String displayName;
        if (favorites.isEmpty()) {
            return null;
        }
        FavoriteTask firstFavoriteTask = favorites.get(0);
        boolean alwaysShowOutput = firstFavoriteTask.alwaysShowOutput();
        if (favorites.size() == 1) {
            displayName = firstFavoriteTask.getDisplayName();
            fullCommandLine = firstFavoriteTask.getFullCommandLine();
        } else {
            displayName = "Multiple (" + firstFavoriteTask.getDisplayName() + ", ... )";
            fullCommandLine = FavoritesEditor.combineFavoriteCommandLines(favorites);
        }
        return this.addExecutionRequestToQueue(fullCommandLine, displayName, alwaysShowOutput);
    }

    public Request addExecutionRequestToQueue(String fullCommandLine, String displayName, boolean forceOutputToBeShown) {
        if (fullCommandLine == null) {
            return null;
        }
        fullCommandLine = this.alterCommandLine(fullCommandLine);
        final ExecutionRequest request = new ExecutionRequest(this.getNextRequestID(), fullCommandLine, displayName, forceOutputToBeShown, this.queueManager);
        this.requestObserverLord.notifyObservers(new ObserverLord.ObserverNotification<RequestObserver>(){

            @Override
            public void notify(RequestObserver observer) {
                observer.executionRequestAdded(request);
            }
        });
        this.queueManager.addRequestToQueue(request);
        return request;
    }

    private synchronized long getNextRequestID() {
        return this.nextRequestID++;
    }

    public Request addRefreshRequestToQueue() {
        return this.addRefreshRequestToQueue(null);
    }

    public Request addRefreshRequestToQueue(String additionalCommandLineArguments) {
        String fullCommandLine = "tasks";
        if (additionalCommandLineArguments != null) {
            fullCommandLine = fullCommandLine + ' ' + additionalCommandLineArguments;
        }
        fullCommandLine = this.alterCommandLine(fullCommandLine);
        List currentRequests = this.queueManager.findRequestsOfType(RefreshTaskListRequest.TYPE);
        for (Request currentRequest : currentRequests) {
            if (!currentRequest.getFullCommandLine().equals(fullCommandLine)) continue;
            return currentRequest;
        }
        final RefreshTaskListRequest request = new RefreshTaskListRequest(this.getNextRequestID(), fullCommandLine, this.queueManager, this);
        this.queueManager.addRequestToQueue(request);
        this.requestObserverLord.notifyObservers(new ObserverLord.ObserverNotification<RequestObserver>(){

            @Override
            public void notify(RequestObserver observer) {
                observer.refreshRequestAdded(request);
            }
        });
        return request;
    }

    private String alterCommandLine(String fullCommandLine) {
        CommandLineArgumentAlteringNotification notification = new CommandLineArgumentAlteringNotification(fullCommandLine);
        this.commandLineArgumentObserverLord.notifyObservers(notification);
        return notification.getFullCommandLine();
    }

    public void addCommandLineArgumentAlteringListener(CommandLineArgumentAlteringListener listener) {
        this.commandLineArgumentObserverLord.addObserver(listener, false);
    }

    public void removeCommandLineArgumentAlteringListener(CommandLineArgumentAlteringListener listener) {
        this.commandLineArgumentObserverLord.removeObserver(listener);
    }

    public static String getGradleExceptionMessage(Throwable failure, ShowStacktrace stackTraceLevel) {
        if (failure == null) {
            return "";
        }
        Formatter formatter = new Formatter();
        formatter.format("%nBuild failed.%n", new Object[0]);
        if (stackTraceLevel == ShowStacktrace.INTERNAL_EXCEPTIONS) {
            formatter.format("Use the stack trace options to get more details.", new Object[0]);
        }
        if (failure != null) {
            formatter.format("%n", new Object[0]);
            if (failure instanceof LocationAwareException) {
                LocationAwareException scriptException = (LocationAwareException)failure;
                formatter.format("%s%n%n", scriptException.getLocation());
                formatter.format("%s", scriptException.getCause().getMessage());
                for (Throwable cause : scriptException.getReportableCauses()) {
                    formatter.format("%nCause: %s", GradlePluginLord.getMessage(cause));
                }
            } else {
                formatter.format("%s", GradlePluginLord.getMessage(failure));
            }
            if (stackTraceLevel != ShowStacktrace.INTERNAL_EXCEPTIONS) {
                formatter.format("%n%nException is:\n", new Object[0]);
                if (stackTraceLevel == ShowStacktrace.ALWAYS_FULL) {
                    return formatter.toString() + GradlePluginLord.getStackTraceAsText(failure);
                }
                return formatter.toString() + GradlePluginLord.getStackTraceAsText(StackTraceUtils.deepSanitize((Throwable)failure));
            }
        }
        return formatter.toString();
    }

    private static String getStackTraceAsText(Throwable t) {
        StringBuilder builder = new StringBuilder();
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        for (int index = 0; index < stackTraceElements.length; ++index) {
            StackTraceElement stackTraceElement = stackTraceElements[index];
            builder.append("   ").append(stackTraceElement.toString()).append('\n');
        }
        return builder.toString();
    }

    private static String getMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (!GUtil.isTrue((Object)message)) {
            message = String.format("%s (no error message)", throwable.getClass().getName());
        }
        if (throwable.getCause() != null) {
            message = message + "\nCaused by: " + GradlePluginLord.getMessage(throwable.getCause());
        }
        return message;
    }

    public boolean isBusy() {
        return !this.queueManager.findRequestsOfType(ExecutionRequest.TYPE).isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueManager
    implements ExecutionQueue.RequestCancellation {
        private final Object lock = new Object();
        private final ExecutionQueue<Request> executionQueue = new ExecutionQueue<Request>(new ExecutionQueueInteraction());
        private final Set<Request> currentlyExecutingRequests = new HashSet<Request>();

        private QueueManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Request> findRequestsOfType(ExecutionQueue.Request.Type type) {
            ArrayList<Request> requests = new ArrayList<Request>();
            Object object = this.lock;
            synchronized (object) {
                for (Request request : this.currentlyExecutingRequests) {
                    if (request.getType() != type) continue;
                    requests.add(request);
                }
            }
            return requests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCancel(ExecutionQueue.Request request) {
            this.executionQueue.removeRequestFromQueue(request);
            Object object = this.lock;
            synchronized (object) {
                this.currentlyExecutingRequests.remove(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(Request request) {
            Object object = this.lock;
            synchronized (object) {
                this.currentlyExecutingRequests.remove(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequestToQueue(Request request) {
            Object object = this.lock;
            synchronized (object) {
                this.currentlyExecutingRequests.add(request);
            }
            this.executionQueue.addRequestToQueue(request);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandLineArgumentAlteringNotification
    implements ObserverLord.ObserverNotification<CommandLineArgumentAlteringListener> {
        private StringBuilder fullCommandLineBuilder;

        private CommandLineArgumentAlteringNotification(String fullCommandLine) {
            this.fullCommandLineBuilder = new StringBuilder(fullCommandLine);
        }

        @Override
        public void notify(CommandLineArgumentAlteringListener observer) {
            String additions = observer.getAdditionalCommandLineArguments(this.fullCommandLineBuilder.toString());
            if (additions != null) {
                this.fullCommandLineBuilder.append(' ').append(additions);
            }
        }

        public String getFullCommandLine() {
            return this.fullCommandLineBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionQueueInteraction
    implements ExecutionQueue.ExecutionInteraction<Request> {
        private ExecutionQueueInteraction() {
        }

        @Override
        public void execute(final Request request) {
            GradlePluginLord.this.notifyAboutToExecuteRequest(request);
            File currentDirectory = GradlePluginLord.this.getCurrentDirectory();
            File gradleHomeDirectory = GradlePluginLord.this.getGradleHomeDirectory();
            File customGradleExecutor = GradlePluginLord.this.getCustomGradleExecutor();
            ProcessLauncherServer.Protocol serverProtocol = request.createServerProtocol(GradlePluginLord.this.logLevel, GradlePluginLord.this.stackTraceLevel, currentDirectory, gradleHomeDirectory, customGradleExecutor);
            ProcessLauncherServer server = new ProcessLauncherServer(serverProtocol);
            request.setProcessLauncherServer(server);
            server.addServerObserver(new ProcessLauncherServer.ServerObserver(){

                public void clientExited(int result, String output) {
                    GradlePluginLord.this.queueManager.onComplete(request);
                    GradlePluginLord.this.notifyRequestExecutionComplete(request, result, output);
                }

                public void serverExited() {
                }
            }, false);
            server.start();
        }
    }

    public static interface SettingsObserver {
        public void settingsChanged();
    }

    public static interface RequestObserver {
        public void executionRequestAdded(ExecutionRequest var1);

        public void refreshRequestAdded(RefreshTaskListRequest var1);

        public void aboutToExecuteRequest(Request var1);

        public void requestExecutionComplete(Request var1, int var2, String var3);
    }

    public static interface GeneralPluginObserver {
        public void startingProjectsAndTasksReload();

        public void projectsAndTasksReloaded(boolean var1);
    }
}

