/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.search;

import java.util.regex.Pattern;

public class BasicTextSearchCriteria {
    private String textToMatch = "";
    private boolean isCaseSensitive;
    private boolean useRegularExpressions;
    private int startingFrom = -1;
    private boolean hasChanged;
    private Pattern regularExpressionPattern;

    public String getTextToMatch() {
        return this.textToMatch;
    }

    public void setTextToMatch(String textToMatch) {
        if (this.textToMatch.equals(textToMatch)) {
            return;
        }
        this.hasChanged = true;
        this.textToMatch = textToMatch;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.isCaseSensitive == caseSensitive) {
            return;
        }
        this.hasChanged = true;
        this.isCaseSensitive = caseSensitive;
    }

    public boolean useRegularExpressions() {
        return this.useRegularExpressions;
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        if (this.useRegularExpressions == useRegularExpressions) {
            return;
        }
        this.hasChanged = true;
        this.useRegularExpressions = useRegularExpressions;
    }

    public Pattern getRegularExpressionPattern() {
        if (this.textToMatch == null || "".equals(this.textToMatch)) {
            return null;
        }
        String actualTextToMatch = this.textToMatch;
        if (!this.useRegularExpressions) {
            actualTextToMatch = Pattern.quote(this.textToMatch);
        }
        if (this.hasChanged || this.regularExpressionPattern == null) {
            this.regularExpressionPattern = this.isCaseSensitive ? Pattern.compile(actualTextToMatch) : Pattern.compile("(?i)" + actualTextToMatch);
        }
        return this.regularExpressionPattern;
    }

    public int getStartingFrom() {
        return this.startingFrom;
    }

    public void setStartingFrom(int startingFrom) {
        if (this.startingFrom == startingFrom) {
            return;
        }
        this.hasChanged = true;
        this.startingFrom = startingFrom;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    void resetHasChanged() {
        this.hasChanged = false;
    }

    public String toString() {
        return '\'' + this.textToMatch + "' Case sensitive: " + this.isCaseSensitive + " Regular Expressions: " + this.useRegularExpressions;
    }
}

