/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.settings;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM4JSettingsNode
implements SettingsNode {
    public static final String TAG_NAME = "setting";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    private Element element;

    public DOM4JSettingsNode(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public void setName(String name) {
        this.element.addAttribute(NAME_ATTRIBUTE, name);
    }

    @Override
    public String getName() {
        return this.element.attributeValue(NAME_ATTRIBUTE);
    }

    @Override
    public void setValue(String value) {
        this.element.addAttribute(VALUE_ATTRIBUTE, value);
    }

    @Override
    public String getValue() {
        return this.element.attributeValue(VALUE_ATTRIBUTE);
    }

    @Override
    public void setValueOfChild(String name, String value) {
        SettingsNode settingsNode = this.addChildIfNotPresent(name);
        settingsNode.setValue(value);
    }

    @Override
    public String getValueOfChild(String name, String defaultValue) {
        String value;
        SettingsNode settingsNode = this.getChildNode(name);
        if (settingsNode != null && (value = settingsNode.getValue()) != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public SettingsNode getChildNode(String name) {
        for (Element childElement : this.element.elements()) {
            if (!name.equals(childElement.attributeValue(NAME_ATTRIBUTE))) continue;
            return new DOM4JSettingsNode(childElement);
        }
        return null;
    }

    @Override
    public List<SettingsNode> getChildNodes() {
        return this.convertNodes(this.element.elements());
    }

    private List<SettingsNode> convertNodes(List elements) {
        ArrayList<SettingsNode> children = new ArrayList<SettingsNode>();
        for (Element childElement : elements) {
            children.add(new DOM4JSettingsNode(childElement));
        }
        return children;
    }

    @Override
    public List<SettingsNode> getChildNodes(String name) {
        ArrayList<SettingsNode> children = new ArrayList<SettingsNode>();
        for (Element childElement : this.element.elements()) {
            if (!name.equals(childElement.attributeValue(NAME_ATTRIBUTE))) continue;
            children.add(new DOM4JSettingsNode(childElement));
        }
        return children;
    }

    @Override
    public int getValueOfChildAsInt(String name, int defaultValue) {
        SettingsNode settingsNode = this.getChildNode(name);
        if (settingsNode != null) {
            String value = settingsNode.getValue();
            try {
                if (value != null) {
                    return Integer.parseInt(value);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void setValueOfChildAsInt(String name, int value) {
        this.setValueOfChild(name, Integer.toString(value));
    }

    @Override
    public long getValueOfChildAsLong(String name, long defaultValue) {
        SettingsNode settingsNode = this.getChildNode(name);
        if (settingsNode != null) {
            String value = settingsNode.getValue();
            try {
                if (value != null) {
                    return Long.parseLong(value);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void setValueOfChildAsLong(String name, long value) {
        this.setValueOfChild(name, Long.toString(value));
    }

    @Override
    public boolean getValueOfChildAsBoolean(String name, boolean defaultValue) {
        String value;
        SettingsNode settingsNode = this.getChildNode(name);
        if (settingsNode != null && (value = settingsNode.getValue()) != null) {
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    @Override
    public void setValueOfChildAsBoolean(String name, boolean value) {
        this.setValueOfChild(name, Boolean.toString(value));
    }

    @Override
    public SettingsNode addChild(String name) {
        DOM4JSettingsNode childElement = new DOM4JSettingsNode(this.element.addElement(TAG_NAME));
        childElement.setName(name);
        return childElement;
    }

    @Override
    public SettingsNode addChildIfNotPresent(String name) {
        SettingsNode settingsNode = this.getChildNode(name);
        if (settingsNode == null) {
            settingsNode = this.addChild(name);
        }
        return settingsNode;
    }

    @Override
    public SettingsNode getNodeAtPath(String ... pathPortions) {
        String pathPortion;
        if (pathPortions == null || pathPortions.length == 0) {
            return null;
        }
        String firstPathPortion = pathPortions[0];
        SettingsNode currentNode = this.getChildNode(firstPathPortion);
        for (int index = 1; index < pathPortions.length && currentNode != null; currentNode = currentNode.getChildNode(pathPortion), ++index) {
            pathPortion = pathPortions[index];
        }
        return currentNode;
    }

    private SettingsNode getNodeAtPathCreateIfNotFound(String ... pathPortions) {
        if (pathPortions == null || pathPortions.length == 0) {
            return null;
        }
        String firstPathPortion = pathPortions[0];
        SettingsNode currentNode = this.getChildNode(firstPathPortion);
        if (currentNode == null) {
            currentNode = this.addChild(firstPathPortion);
        }
        for (int index = 1; index < pathPortions.length; ++index) {
            String pathPortion = pathPortions[index];
            if ((currentNode = currentNode.getChildNode(pathPortion)) != null) continue;
            currentNode = this.addChild(firstPathPortion);
        }
        return currentNode;
    }

    @Override
    public void removeFromParent() {
        this.element.detach();
    }

    @Override
    public void removeAllChildren() {
        List list = this.element.elements();
        for (Element child : list) {
            child.detach();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DOM4JSettingsNode)) {
            return false;
        }
        DOM4JSettingsNode otherNode = (DOM4JSettingsNode)obj;
        return otherNode.element.equals(this.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return this.getName() + "='" + this.getValue() + "' " + this.element.elements().size() + " children";
    }
}

