/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.foundation.visitors.TaskTreePopulationVisitor;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.filters.ProjectAndTaskFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTreeComponent {
    private GradlePluginLord gradlePluginLord;
    private Interaction interaction;
    private JTree tree;
    private DefaultTreeModel model;
    private TaskTreeBaseNode rootNode;
    private boolean isPopulated;
    private Renderer renderer;

    public TaskTreeComponent(GradlePluginLord gradlePluginLord, Interaction interaction) {
        this.gradlePluginLord = gradlePluginLord;
        this.interaction = interaction;
        this.createTreePanel();
    }

    private void createTreePanel() {
        this.rootNode = new TaskTreeBaseNode();
        this.model = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.renderer = new Renderer();
        this.tree.setCellRenderer(this.renderer);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setToggleClickCount(99);
        this.tree.addMouseListener(new MyMouseListener());
        this.tree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeComponent.this.executeFirstSelectedNode(false);
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.tree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeComponent.this.executeFirstSelectedNode(true);
            }
        }, KeyStroke.getKeyStroke(10, 2), 2);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.tree.setCellRenderer(renderer);
    }

    public void populate(ProjectAndTaskFilter filter) {
        TaskTreePopulationVisitor.visitProjectAndTasks(this.gradlePluginLord.getProjects(), new PopulateTreeVisitor(), filter, this.rootNode);
        this.model.reload();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TaskTreeComponent.this.tree.expandRow(0);
            }
        });
        this.isPopulated = true;
    }

    public boolean isPopulated() {
        return this.isPopulated;
    }

    private void expandNode(TreeNode node) {
        this.tree.expandPath(new TreePath(node));
    }

    public TaskTreeBaseNode getNodeAtPoint(Point point) {
        int row = this.tree.getRowForLocation(point.x, point.y);
        if (row == -1) {
            return null;
        }
        TreePath path = this.tree.getPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        return (TaskTreeBaseNode)path.getLastPathComponent();
    }

    public TaskTreeBaseNode getFirstSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (TaskTreeBaseNode)path.getLastPathComponent();
    }

    public List<TaskTreeBaseNode> getSelectedNodes() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return Collections.emptyList();
        }
        ArrayList<TaskTreeBaseNode> nodes = new ArrayList<TaskTreeBaseNode>();
        for (int index = 0; index < treePaths.length; ++index) {
            TreePath treePath = treePaths[index];
            nodes.add((TaskTreeBaseNode)treePath.getLastPathComponent());
        }
        return nodes;
    }

    public boolean hasProjectsSelected() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (int index = 0; index < treePaths.length; ++index) {
            TreePath treePath = treePaths[index];
            Object o = treePath.getLastPathComponent();
            if (!(o instanceof ProjectTreeNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTasksSelected() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (int index = 0; index < treePaths.length; ++index) {
            TreePath treePath = treePaths[index];
            Object o = treePath.getLastPathComponent();
            if (!(o instanceof TaskTreeNode)) continue;
            return true;
        }
        return false;
    }

    public List<TaskView> getSelectedTasks() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return Collections.emptyList();
        }
        ArrayList<TaskView> tasks = new ArrayList<TaskView>();
        for (int index = 0; index < treePaths.length; ++index) {
            TreePath treePath = treePaths[index];
            Object o = treePath.getLastPathComponent();
            if (!(o instanceof TaskTreeNode)) continue;
            tasks.add(((TaskTreeNode)o).task);
        }
        return tasks;
    }

    public MultipleSelection getSelectedProjectsAndTasks() {
        MultipleSelection multipleSelection = new MultipleSelection();
        TreePath[] treePaths = this.tree.getSelectionPaths();
        if (treePaths == null) {
            return multipleSelection;
        }
        for (int index = 0; index < treePaths.length; ++index) {
            TreePath treePath = treePaths[index];
            Object o = treePath.getLastPathComponent();
            if (o instanceof TaskTreeNode) {
                multipleSelection.tasks.add(((TaskTreeNode)o).getTask());
                continue;
            }
            if (!(o instanceof ProjectTreeNode)) continue;
            multipleSelection.projects.add(((ProjectTreeNode)o).getProject());
        }
        return multipleSelection;
    }

    public boolean showDescription() {
        return this.renderer.showDescription();
    }

    public void setShowDescription(boolean showDescription) {
        this.renderer.setShowDescription(showDescription);
    }

    private void executeFirstSelectedNode(boolean isCtrlKeyDown) {
        TaskTreeBaseNode node = this.getFirstSelectedNode();
        if (node != null) {
            node.executeTask(isCtrlKeyDown);
        }
    }

    public class MultipleSelection {
        public List<ProjectView> projects = new ArrayList<ProjectView>();
        public List<TaskView> tasks = new ArrayList<TaskView>();
    }

    public class TaskTreeNode
    extends TaskTreeBaseNode {
        private TaskView task;

        private TaskTreeNode(TaskView task) {
            this.task = task;
        }

        public String toString() {
            return this.task.getName();
        }

        public void executeTask(boolean isCtrlKeyDown) {
            TaskTreeComponent.this.interaction.taskInvoked(this.task, isCtrlKeyDown);
        }

        public TaskView getTask() {
            return this.task;
        }

        public String getDescription() {
            return this.task.getDescription();
        }

        public boolean isBold() {
            return this.task.isDefault();
        }
    }

    public class ProjectTreeNode
    extends TaskTreeBaseNode {
        private ProjectView project;

        private ProjectTreeNode(ProjectView project) {
            this.project = project;
        }

        public String toString() {
            return this.project.getName();
        }

        public void executeTask(boolean isCtrlKeyDown) {
            TaskTreeComponent.this.interaction.projectInvoked(this.project);
        }

        public String getDescription() {
            return this.project.getDescription();
        }

        public ProjectView getProject() {
            return this.project;
        }
    }

    public class TaskTreeBaseNode
    extends DefaultMutableTreeNode {
        public void executeTask(boolean isCtrlKeyDown) {
        }

        public String toString() {
            return "hidden-root";
        }

        public String getDescription() {
            return null;
        }

        public boolean isBold() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopulateTreeVisitor
    implements TaskTreePopulationVisitor.Visitor<TaskTreeBaseNode, TaskTreeNode> {
        private PopulateTreeVisitor() {
        }

        @Override
        public TaskTreeBaseNode visitProject(ProjectView project, int indexOfProject, TaskTreeBaseNode parentProjectObject) {
            int actualIndex;
            ProjectTreeNode projectTreeNode = this.findProjectChild(parentProjectObject, project.getName());
            if (projectTreeNode == null) {
                projectTreeNode = new ProjectTreeNode(project);
            }
            if ((actualIndex = parentProjectObject.getIndex(projectTreeNode)) != indexOfProject) {
                if (actualIndex != -1) {
                    TaskTreeComponent.this.model.removeNodeFromParent(projectTreeNode);
                }
                this.insertChildNode(parentProjectObject, projectTreeNode, indexOfProject);
            }
            return projectTreeNode;
        }

        private ProjectTreeNode findProjectChild(TaskTreeBaseNode parentNode, String projectName) {
            for (int index = 0; index < parentNode.getChildCount(); ++index) {
                TreeNode child = parentNode.getChildAt(index);
                if (!(child instanceof ProjectTreeNode) || !((ProjectTreeNode)child).getProject().getName().equals(projectName)) continue;
                return (ProjectTreeNode)child;
            }
            return null;
        }

        @Override
        public TaskTreeNode visitTask(TaskView task, int indexOfTask, ProjectView tasksProject, TaskTreeBaseNode parentTreeNode) {
            int actualIndex;
            TaskTreeNode taskTreeNode = this.findTaskChild((ProjectTreeNode)parentTreeNode, task.getName());
            if (taskTreeNode == null) {
                taskTreeNode = new TaskTreeNode(task);
            }
            if ((actualIndex = parentTreeNode.getIndex(taskTreeNode)) != indexOfTask) {
                if (actualIndex != -1) {
                    TaskTreeComponent.this.model.removeNodeFromParent(taskTreeNode);
                }
                this.insertChildNode(parentTreeNode, taskTreeNode, indexOfTask);
            }
            return taskTreeNode;
        }

        private void insertChildNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode child, int index) {
            if (parent.getChildCount() < index) {
                parent.add(child);
                TaskTreeComponent.this.model.nodesWereInserted(parent, new int[]{parent.getChildCount() - 1});
            } else {
                parent.insert(child, index);
                TaskTreeComponent.this.model.nodesWereInserted(parent, new int[]{index});
            }
        }

        private TaskTreeNode findTaskChild(ProjectTreeNode parentNode, String taskName) {
            for (int index = 0; index < parentNode.getChildCount(); ++index) {
                TreeNode child = parentNode.getChildAt(index);
                if (!(child instanceof TaskTreeNode) || !((TaskTreeNode)child).getTask().getName().equals(taskName)) continue;
                return (TaskTreeNode)child;
            }
            return null;
        }

        @Override
        public void completedVisitingProject(TaskTreeBaseNode parentProjectObject, List<TaskTreeBaseNode> projectObjects, List<TaskTreeNode> taskObjects) {
            int index = 0;
            while (index < parentProjectObject.getChildCount()) {
                TaskTreeBaseNode child = (TaskTreeBaseNode)parentProjectObject.getChildAt(index);
                if (!projectObjects.contains(child) && !taskObjects.contains(child)) {
                    TaskTreeComponent.this.model.removeNodeFromParent(child);
                    continue;
                }
                ++index;
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                Point point = e.getPoint();
                int row = TaskTreeComponent.this.tree.getRowForLocation(point.x, point.y);
                if (row != -1) {
                    if (TaskTreeComponent.this.tree.isRowSelected(row)) {
                        return;
                    }
                    if (this.isAddToSelectionKey(e)) {
                        TaskTreeComponent.this.tree.addSelectionRow(row);
                    } else {
                        TaskTreeComponent.this.tree.setSelectionRow(row);
                    }
                }
            }
        }

        private boolean isAddToSelectionKey(MouseEvent e) {
            return (e.getModifiers() & 2) != 0;
        }

        public void mouseClicked(MouseEvent e) {
            TaskTreeBaseNode node;
            if (e.getClickCount() == 1) {
                if (e.getButton() == 3) {
                    Point point = e.getPoint();
                    TaskTreeComponent.this.interaction.rightClick(TaskTreeComponent.this.tree, point.x, point.y);
                }
            } else if (e.getClickCount() == 2 && (node = TaskTreeComponent.this.getNodeAtPoint(e.getPoint())) != null) {
                boolean isCtrlKeyDown = (e.getModifiers() & 2) != 0;
                node.executeTask(isCtrlKeyDown);
            }
        }
    }

    private class Renderer
    implements TreeCellRenderer {
        private JPanel panel;
        private DefaultTreeCellRenderer nameRenderer;
        private DefaultTreeCellRenderer descriptionRenderer;
        private Color descriptionColor;
        private boolean showDescription = true;
        private Component seperator;
        private Font normalFont;
        private Font boldFont;

        private Renderer() {
            this.setupRendererUI();
            this.setShowDescription(true);
            this.descriptionColor = Color.blue;
        }

        private void setupRendererUI() {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.nameRenderer = new DefaultTreeCellRenderer();
            this.descriptionRenderer = new DefaultTreeCellRenderer();
            this.panel.add(this.nameRenderer);
            this.seperator = Box.createHorizontalStrut(10);
            this.panel.add(this.seperator);
            this.panel.add(this.descriptionRenderer);
            this.panel.setOpaque(false);
            this.setupFonts();
        }

        private void setupFonts() {
            this.normalFont = this.nameRenderer.getFont().deriveFont(0);
            this.boldFont = this.normalFont.deriveFont(1);
            this.nameRenderer.setFont(this.normalFont);
            this.descriptionRenderer.setFont(this.normalFont);
        }

        public boolean showDescription() {
            return this.showDescription;
        }

        public void setShowDescription(boolean showDescription) {
            this.showDescription = showDescription;
            this.seperator.setVisible(showDescription);
            this.descriptionRenderer.setVisible(showDescription);
            this.seperator.invalidate();
            this.nameRenderer.invalidate();
            this.descriptionRenderer.invalidate();
            this.panel.invalidate();
            Enumeration<TreeNode> enumeration = TaskTreeComponent.this.rootNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TaskTreeBaseNode treeNode = (TaskTreeBaseNode)enumeration.nextElement();
                TaskTreeComponent.this.model.nodeChanged(treeNode);
            }
            TaskTreeComponent.this.tree.repaint();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TaskTreeBaseNode node = (TaskTreeBaseNode)value;
            String description = node.getDescription();
            this.nameRenderer.getTreeCellRendererComponent(tree, node.toString(), isSelected, expanded, leaf, row, hasFocus);
            this.descriptionRenderer.getTreeCellRendererComponent(tree, description, isSelected, expanded, leaf, row, false);
            this.panel.setToolTipText(description);
            this.nameRenderer.setIcon(null);
            this.descriptionRenderer.setIcon(null);
            if (node.isBold()) {
                this.nameRenderer.setFont(this.boldFont);
            } else {
                this.nameRenderer.setFont(this.normalFont);
            }
            if (!isSelected) {
                this.descriptionRenderer.setForeground(this.descriptionColor);
            } else {
                this.descriptionRenderer.setForeground(this.nameRenderer.getForeground());
            }
            this.nameRenderer.invalidate();
            this.descriptionRenderer.invalidate();
            this.seperator.invalidate();
            this.panel.invalidate();
            this.panel.validate();
            return this.panel;
        }
    }

    public static interface Interaction {
        public void rightClick(JTree var1, int var2, int var3);

        public void projectInvoked(ProjectView var1);

        public void taskInvoked(TaskView var1, boolean var2);
    }
}

