/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.http;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcClient;

public class GitAskPassApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("No arguments specified!");
            }
            Pair<Boolean, String> arguments = GitAskPassApp.parseArguments(args[0]);
            boolean usernameNeeded = (Boolean)arguments.getFirst();
            String url = (String)arguments.getSecond();
            int handler = Integer.parseInt(GitAskPassApp.getNotNull("GIT_ASKPASS_HANDLER"));
            int xmlRpcPort = Integer.parseInt(GitAskPassApp.getNotNull("GIT_ASKPASS_PORT"));
            GitAskPassXmlRpcClient xmlRpcClient = new GitAskPassXmlRpcClient(xmlRpcPort);
            if (usernameNeeded) {
                String username = xmlRpcClient.askUsername(handler, url);
                System.out.println(username);
            } else {
                String pass = xmlRpcClient.askPassword(handler, url);
                System.out.println(pass);
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    private static String getNotNull(String env) {
        String handlerValue = System.getenv(env);
        if (handlerValue == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        return handlerValue;
    }

    private static Pair<Boolean, String> parseArguments(String arg) {
        boolean username = StringUtilRt.startsWithIgnoreCase((String)arg, (String)"username");
        String[] split = arg.split(" ");
        String url = split.length > 2 ? GitAskPassApp.parseUrl(split[2]) : "";
        return Pair.create((Object)username, (Object)url);
    }

    private static String parseUrl(String urlArg) {
        String url = urlArg;
        if (url.startsWith("'")) {
            url = url.substring(1);
        }
        if (url.endsWith(":")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("'")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

