/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.artifact.installer;

import java.io.File;
import org.gradle.mvn3.org.apache.maven.RepositoryUtils;
import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.gradle.mvn3.org.apache.maven.artifact.installer.ArtifactInstaller;
import org.gradle.mvn3.org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.mvn3.org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.MetadataBridge;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Snapshot;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.mvn3.org.apache.maven.plugin.LegacySupport;
import org.gradle.mvn3.org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.AbstractLogEnabled;
import org.gradle.mvn3.org.sonatype.aether.RepositorySystem;
import org.gradle.mvn3.org.sonatype.aether.RepositorySystemSession;
import org.gradle.mvn3.org.sonatype.aether.installation.InstallRequest;
import org.gradle.mvn3.org.sonatype.aether.installation.InstallationException;
import org.gradle.mvn3.org.sonatype.aether.metadata.Metadata;
import org.gradle.mvn3.org.sonatype.aether.util.DefaultRequestTrace;
import org.gradle.mvn3.org.sonatype.aether.util.artifact.SubArtifact;

@Component(role=ArtifactInstaller.class)
public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private LegacySupport legacySupport;

    @Deprecated
    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.install(source, artifact, localRepository);
    }

    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay((ArtifactRepository)localRepository, (RepositorySystemSession)this.legacySupport.getRepositorySession(), (RepositorySystem)this.repoSystem);
        InstallRequest request = new InstallRequest();
        request.setTrace(DefaultRequestTrace.newChild(null, (Object)this.legacySupport.getSession().getCurrentProject()));
        org.gradle.mvn3.org.sonatype.aether.artifact.Artifact mainArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        mainArtifact = mainArtifact.setFile(source);
        request.addArtifact(mainArtifact);
        for (ArtifactMetadata metadata : artifact.getMetadataList()) {
            if (metadata instanceof ProjectArtifactMetadata) {
                SubArtifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                request.addArtifact((org.gradle.mvn3.org.sonatype.aether.artifact.Artifact)pomArtifact);
                continue;
            }
            if (metadata instanceof SnapshotArtifactRepositoryMetadata || metadata instanceof ArtifactRepositoryMetadata) continue;
            request.addMetadata((Metadata)new MetadataBridge(metadata));
        }
        try {
            this.repoSystem.install(session, request);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallationException(e.getMessage(), e);
        }
        if (artifact.isSnapshot()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setLocalCopy(true);
            artifact.addMetadata((ArtifactMetadata)new SnapshotArtifactRepositoryMetadata(artifact, snapshot));
        }
        Versioning versioning = new Versioning();
        versioning.updateTimestamp();
        versioning.addVersion(artifact.getBaseVersion());
        if (artifact.isRelease()) {
            versioning.setRelease(artifact.getBaseVersion());
        }
        artifact.addMetadata((ArtifactMetadata)new ArtifactRepositoryMetadata(artifact, versioning));
    }
}

