/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.io.NonClosingInputStream;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.repository.SdkStatsConstants;
import com.android.utils.SparseArray;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SdkStats {
    private final SparseArray<PlatformStat> mStats = new SparseArray();

    public SparseArray<PlatformStat> getStats() {
        return this.mStats;
    }

    public void load(DownloadCache cache, boolean forceHttp, ITaskMonitor monitor) {
        String url = "https://dl.google.com/android/repository/stats-1.xml";
        if (forceHttp) {
            url = url.replaceAll("https://", "http://");
        }
        monitor.setProgressMax(5);
        monitor.setDescription("Fetching %1$s", url);
        monitor.incProgress(1);
        Exception[] exception = new Exception[]{null};
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Document validatedDoc = null;
        String validatedUri = null;
        InputStream xml = this.fetchXmlUrl(url, cache, monitor.createSubMonitor(1), exception);
        if (xml != null) {
            monitor.setDescription("Validate XML", new Object[0]);
            int version = this.getXmlSchemaVersion(xml);
            if (version >= 1 && version <= 1) {
                String uri = this.validateXml(xml, url, version, validationError, validatorFound);
                if (uri != null) {
                    validatedDoc = this.getDocument(xml, monitor);
                    validatedUri = uri;
                }
            } else if (version > 1) {
                this.closeStream(xml);
                return;
            }
        }
        if (exception[0] != null) {
            String reason = null;
            reason = exception[0] instanceof FileNotFoundException ? "File not found" : (exception[0] instanceof UnknownHostException && exception[0].getMessage() != null ? String.format("Unknown Host %1$s", exception[0].getMessage()) : (exception[0] instanceof SSLKeyException ? "HTTPS SSL error. You might want to force download through HTTP in the settings." : (exception[0].getMessage() != null ? exception[0].getMessage() : String.format("Unknown (%1$s)", exception[0].getClass().getName()))));
            monitor.logError("Failed to fetch URL %1$s, reason: %2$s", url, reason);
        }
        if (validationError[0] != null) {
            monitor.logError("%s", validationError[0]);
        }
        if (validatedDoc == null) {
            this.closeStream(xml);
            return;
        }
        monitor.incProgress(1);
        if (xml != null) {
            monitor.setDescription("Parse XML", new Object[0]);
            monitor.incProgress(1);
            this.parseStatsDocument(validatedDoc, validatedUri, monitor);
        }
        monitor.incProgress(1);
        this.closeStream(xml);
    }

    private InputStream fetchXmlUrl(String urlString, DownloadCache cache, ITaskMonitor monitor, Exception[] outException) {
        try {
            InputStream xml = cache.openCachedUrl(urlString, monitor);
            if (xml != null) {
                xml.mark(500000);
                xml = new NonClosingInputStream(xml);
                ((NonClosingInputStream)xml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            return xml;
        }
        catch (Exception e) {
            if (outException != null) {
                outException[0] = e;
            }
            return null;
        }
    }

    private void closeStream(InputStream is) {
        if (is != null) {
            if (is instanceof NonClosingInputStream) {
                ((NonClosingInputStream)is).setCloseBehavior(NonClosingInputStream.CloseBehavior.CLOSE);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile("http://schemas.android.com/sdk/android/stats/([1-9][0-9]*)");
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!"sdk-stats".equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            String xmlns = "xmlns";
            if (prefix != null) {
                xmlns = xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem(xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            xml.reset();
            validator.validate(new StreamSource(xml));
            return SdkStatsConstants.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator getValidator(int version) throws SAXException {
        Validator validator;
        InputStream xsdStream = SdkStatsConstants.getXsdStream(version);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            Validator validator2 = null;
            return validator2;
        }
        Schema schema = factory.newSchema(new StreamSource(xsdStream));
        Validator validator3 = validator = schema == null ? null : schema.newValidator();
        return validator3;
        finally {
            if (xsdStream != null) {
                try {
                    xsdStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected Document getDocument(InputStream xml, ITaskMonitor monitor) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            monitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException e) {
            monitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException e) {
            monitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }

    protected SparseArray<PlatformStat> parseStatsDocument(Document doc, String nsUri, ITaskMonitor monitor) {
        String baseUrl = System.getenv("SDK_TEST_BASE_URL");
        if (!(baseUrl == null || baseUrl.length() > 0 && baseUrl.endsWith("/"))) {
            baseUrl = null;
        }
        SparseArray platforms = new SparseArray();
        int maxApi = 0;
        Node root = this.getFirstChild(doc, nsUri, "sdk-stats");
        if (root != null) {
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("platform")) continue;
                try {
                    float percent;
                    Node node = this.getFirstChild(child, nsUri, "api-level");
                    int apiLevel = Integer.parseInt(node.getTextContent().trim());
                    if (apiLevel < 1 || platforms.indexOfKey(apiLevel) >= 0) continue;
                    String codeName = this.getFirstChild(child, nsUri, "codename").getTextContent().trim();
                    String versName = this.getFirstChild(child, nsUri, "version").getTextContent().trim();
                    if (codeName == null || versName == null || codeName.length() == 0 || versName.length() == 0 || (percent = Float.parseFloat((node = this.getFirstChild(child, nsUri, "share")).getTextContent().trim())) < 0.0f || percent > 100.0f) continue;
                    PlatformStatBase p = new PlatformStatBase(apiLevel, versName, codeName, percent);
                    platforms.put(apiLevel, (Object)p);
                    maxApi = apiLevel > maxApi ? apiLevel : maxApi;
                    continue;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        this.mStats.clear();
        for (int api = 1; api <= maxApi; ++api) {
            PlatformStatBase p = (PlatformStatBase)platforms.get(api);
            if (p == null) continue;
            float sum = p.getShare();
            for (int j = api + 1; j <= maxApi; ++j) {
                PlatformStatBase pj = (PlatformStatBase)platforms.get(j);
                if (pj == null) continue;
                sum += pj.getShare();
            }
            this.mStats.put(api, (Object)new PlatformStat(p, sum));
        }
        return this.mStats;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    public static class PlatformStat
    extends PlatformStatBase {
        private final float mAccumShare;

        public PlatformStat(int apiLevel, String versionName, String codeName, float share, float accumShare) {
            super(apiLevel, versionName, codeName, share);
            this.mAccumShare = accumShare;
        }

        public PlatformStat(PlatformStatBase base, float accumShare) {
            super(base.getApiLevel(), base.getVersionName(), base.getCodeName(), base.getShare());
            this.mAccumShare = accumShare;
        }

        public float getAccumShare() {
            return this.mAccumShare;
        }

        @Override
        public String toString() {
            return String.format("<Stat %s, accum=%.1f%%>", super.toString(), Float.valueOf(this.mAccumShare));
        }
    }

    public static class PlatformStatBase {
        private final int mApiLevel;
        private final String mVersionName;
        private final String mCodeName;
        private final float mShare;

        public PlatformStatBase(int apiLevel, String versionName, String codeName, float share) {
            this.mApiLevel = apiLevel;
            this.mVersionName = versionName;
            this.mCodeName = codeName;
            this.mShare = share;
        }

        public int getApiLevel() {
            return this.mApiLevel;
        }

        public String getCodeName() {
            return this.mCodeName;
        }

        public String getVersionName() {
            return this.mVersionName;
        }

        public float getShare() {
            return this.mShare;
        }

        public String toString() {
            return String.format("api=%d, code=%s, vers=%s, share=%.1f%%", this.mApiLevel, this.mCodeName, this.mVersionName, Float.valueOf(this.mShare));
        }
    }
}

