/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.archives;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.archives.ArchFilter;
import com.android.sdklib.internal.repository.archives.BitSize;
import com.android.sdklib.internal.repository.archives.ChecksumType;
import com.android.sdklib.internal.repository.archives.HostOs;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.util.Properties;

public class Archive
implements IDescription,
Comparable<Archive> {
    private final String mUrl;
    private final long mSize;
    private final String mChecksum;
    private final ChecksumType mChecksumType = ChecksumType.SHA1;
    private final Package mPackage;
    private final String mLocalOsPath;
    private final boolean mIsLocal;
    private final ArchFilter mArchFilter;

    public Archive(@Nullable Package pkg, @Nullable ArchFilter archFilter, @Nullable String url, long size, @NonNull String checksum) {
        this.mPackage = pkg;
        this.mArchFilter = archFilter != null ? archFilter : new ArchFilter(null);
        this.mUrl = url == null ? null : url.trim();
        this.mLocalOsPath = null;
        this.mSize = size;
        this.mChecksum = checksum;
        this.mIsLocal = false;
    }

    public Archive(@NonNull Package pkg, @Nullable Properties props, @Nullable String localOsPath) {
        this.mPackage = pkg;
        this.mArchFilter = new ArchFilter(props);
        this.mUrl = null;
        this.mLocalOsPath = localOsPath;
        this.mSize = 0L;
        this.mChecksum = "";
        this.mIsLocal = localOsPath != null;
    }

    void saveProperties(@NonNull Properties props) {
        this.mArchFilter.saveProperties(props);
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    @Nullable
    public Package getParentPackage() {
        return this.mPackage;
    }

    public long getSize() {
        return this.mSize;
    }

    @NonNull
    public String getChecksum() {
        return this.mChecksum;
    }

    @NonNull
    public ChecksumType getChecksumType() {
        return this.mChecksumType;
    }

    @Nullable
    public String getUrl() {
        return this.mUrl;
    }

    @Nullable
    public String getLocalOsPath() {
        return this.mLocalOsPath;
    }

    @NonNull
    public ArchFilter getArchFilter() {
        return this.mArchFilter;
    }

    public String getOsDescription() {
        BitSize hostBits;
        StringBuilder sb = new StringBuilder();
        HostOs hos = this.mArchFilter.getHostOS();
        sb.append(hos == null ? "any OS" : hos.getUiName());
        BitSize jvmBits = this.mArchFilter.getJvmBits();
        if (jvmBits != null) {
            sb.append(", JVM ").append(jvmBits.getSize()).append("-bits");
        }
        if ((hostBits = this.mArchFilter.getJvmBits()) != null) {
            sb.append(", Host ").append(hostBits.getSize()).append("-bits");
        }
        return sb.toString();
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    @Override
    public String getShortDescription() {
        return String.format("Archive for %1$s", this.getOsDescription());
    }

    @Override
    public String getLongDescription() {
        return String.format("%1$s\n%2$s\n%3$s", this.getShortDescription(), this.getSizeDescription(), this.getSha1Description());
    }

    public String getSizeDescription() {
        long size = this.getSize();
        String sizeStr = size < 1024L ? String.format("%d Bytes", size) : (size < 0x100000L ? String.format("%d KiB", Math.round((double)size / 1024.0)) : (size < 0x40000000L ? String.format("%.1f MiB", (double)Math.round(10.0 * (double)size / 1048576.0) / 10.0) : String.format("%.1f GiB", (double)Math.round(10.0 * (double)size / 1.073741824E9) / 10.0)));
        return String.format("Size: %1$s", sizeStr);
    }

    public String getSha1Description() {
        return String.format("SHA1: %1$s", this.getChecksum());
    }

    public boolean isCompatible() {
        ArchFilter current = ArchFilter.getCurrent();
        return this.mArchFilter.isCompatibleWith(current);
    }

    public void deleteLocal() {
        if (this.isLocal()) {
            new FileOp().deleteFileOrFolder(new File(this.getLocalOsPath()));
        }
    }

    @Override
    public int compareTo(Archive rhs) {
        if (this.mPackage != null && rhs != null) {
            return this.mPackage.compareTo(rhs.getParentPackage());
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mArchFilter == null ? 0 : this.mArchFilter.hashCode());
        result = 31 * result + (this.mChecksum == null ? 0 : this.mChecksum.hashCode());
        result = 31 * result + (this.mChecksumType == null ? 0 : this.mChecksumType.hashCode());
        result = 31 * result + (this.mIsLocal ? 1231 : 1237);
        result = 31 * result + (this.mLocalOsPath == null ? 0 : this.mLocalOsPath.hashCode());
        result = 31 * result + (int)(this.mSize ^ this.mSize >>> 32);
        result = 31 * result + (this.mUrl == null ? 0 : this.mUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)obj;
        if (this.mArchFilter == null ? other.mArchFilter != null : !this.mArchFilter.equals(other.mArchFilter)) {
            return false;
        }
        if (this.mChecksum == null ? other.mChecksum != null : !this.mChecksum.equals(other.mChecksum)) {
            return false;
        }
        if (this.mChecksumType == null ? other.mChecksumType != null : !this.mChecksumType.equals((Object)other.mChecksumType)) {
            return false;
        }
        if (this.mIsLocal != other.mIsLocal) {
            return false;
        }
        if (this.mLocalOsPath == null ? other.mLocalOsPath != null : !this.mLocalOsPath.equals(other.mLocalOsPath)) {
            return false;
        }
        if (this.mSize != other.mSize) {
            return false;
        }
        return !(this.mUrl == null ? other.mUrl != null : !this.mUrl.equals(other.mUrl));
    }
}

