/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.capitalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;

public class TitleCapitalizationInspection
extends BaseJavaLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    public String getGroupDisplayName() {
        return "Plugin DevKit";
    }

    public String getDisplayName() {
        return "Incorrect dialog title capitalization";
    }

    public String getShortName() {
        return "DialogTitleCapitalization";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiType type = method.getReturnType();
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.String")) {
                    return;
                }
                Collection statements = PsiTreeUtil.findChildrenOfType((PsiElement)method, PsiReturnStatement.class);
                for (PsiReturnStatement returnStatement : statements) {
                    PsiExpression expression = returnStatement.getReturnValue();
                    String value = TitleCapitalizationInspection.getTitleValue(expression);
                    if (value == null) continue;
                    Nls.Capitalization capitalization = TitleCapitalizationInspection.this.getCapitalizationFromAnno((PsiModifierListOwner)method);
                    TitleCapitalizationInspection.checkCapitalization(expression, holder, capitalization);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod != null) {
                    PsiExpression[] args = expression.getArgumentList().getExpressions();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    for (int i = 0; i < Math.min(parameters.length, args.length); ++i) {
                        PsiParameter parameter = parameters[i];
                        Nls.Capitalization capitalization = TitleCapitalizationInspection.this.getCapitalizationFromAnno((PsiModifierListOwner)parameter);
                        TitleCapitalizationInspection.checkCapitalization(args[i], holder, capitalization);
                    }
                }
            }
        };
    }

    public Nls.Capitalization getCapitalizationFromAnno(PsiModifierListOwner modifierListOwner) {
        PsiAnnotation nls = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)modifierListOwner, Collections.singleton(Nls.class.getName()));
        if (nls == null) {
            return Nls.Capitalization.NotSpecified;
        }
        PsiAnnotationMemberValue capitalization = nls.findAttributeValue("capitalization");
        Object cap = JavaPsiFacade.getInstance((Project)modifierListOwner.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)capitalization);
        return cap instanceof Nls.Capitalization ? (Nls.Capitalization)cap : Nls.Capitalization.NotSpecified;
    }

    private static void checkCapitalization(PsiExpression element, ProblemsHolder holder, Nls.Capitalization capitalization) {
        if (capitalization == Nls.Capitalization.NotSpecified) {
            return;
        }
        String titleValue = TitleCapitalizationInspection.getTitleValue(element);
        if (!TitleCapitalizationInspection.checkCapitalization(titleValue, capitalization)) {
            holder.registerProblem((PsiElement)element, "String '" + titleValue + "' is not properly capitalized. It should have " + StringUtil.toLowerCase((String)capitalization.toString()) + " capitalization", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TitleCapitalizationFix(titleValue, capitalization)});
        }
    }

    private static String getTitleValue(PsiExpression arg) {
        PsiElement result;
        Object value;
        if (arg instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)arg).getValue()) instanceof String) {
            return (String)value;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod psiMethod = ((PsiMethodCallExpression)arg).resolveMethod();
            PsiExpression returnValue = PropertyUtil.getGetterReturnExpression((PsiMethod)psiMethod);
            if (arg == returnValue) {
                return null;
            }
            if (returnValue != null) {
                return TitleCapitalizationInspection.getTitleValue(returnValue);
            }
            Property propertyArgument = TitleCapitalizationInspection.getPropertyArgument((PsiMethodCallExpression)arg);
            if (propertyArgument != null) {
                return propertyArgument.getUnescapedValue();
            }
        }
        if (arg instanceof PsiReferenceExpression && (result = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable && ((PsiVariable)result).hasModifierProperty("final")) {
            return TitleCapitalizationInspection.getTitleValue(((PsiVariable)result).getInitializer());
        }
        return null;
    }

    private static Property getPropertyArgument(PsiMethodCallExpression arg) {
        PsiExpression[] args = arg.getArgumentList().getExpressions();
        if (args.length > 0) {
            PsiReference[] references;
            for (PsiReference reference : references = args[0].getReferences()) {
                PsiElement element;
                ResolveResult[] resolveResults;
                if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
                return (Property)element;
            }
        }
        return null;
    }

    private static boolean checkCapitalization(String value, Nls.Capitalization capitalization) {
        if (StringUtil.isEmpty((String)value) || capitalization == Nls.Capitalization.NotSpecified) {
            return true;
        }
        value = value.replace("&", "");
        return capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)value).equals(value) : TitleCapitalizationInspection.checkSentenceCapitalization(value);
    }

    private static boolean checkSentenceCapitalization(String value) {
        String[] words = value.split(" ");
        if (words.length == 0) {
            return true;
        }
        if (!StringUtil.isCapitalized((String)words[0])) {
            return false;
        }
        for (int i = 1; i < words.length; ++i) {
            String word = words[i];
            if (!StringUtil.isCapitalized((String)word)) continue;
            return false;
        }
        return true;
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final String myTitleValue;
        private final Nls.Capitalization myCapitalization;

        public TitleCapitalizationFix(String titleValue, Nls.Capitalization capitalization) {
            this.myTitleValue = titleValue;
            this.myCapitalization = capitalization;
        }

        public String getName() {
            return "Properly capitalize '" + this.myTitleValue + '\'';
        }

        public final void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement problemElement = descriptor.getPsiElement();
            if (problemElement == null || !problemElement.isValid()) {
                return;
            }
            if (TitleCapitalizationFix.isQuickFixOnReadOnlyFile(problemElement)) {
                return;
            }
            try {
                this.doFix(project, problemElement);
            }
            catch (IncorrectOperationException e) {
                Class<?> aClass = this.getClass();
                String className = aClass.getName();
                Logger logger = Logger.getInstance((String)className);
                logger.error((Throwable)e);
            }
        }

        protected void doFix(Project project, PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
                Object value = literalExpression.getValue();
                if (!(value instanceof String)) {
                    return;
                }
                String string = (String)value;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText('\"' + this.fixValue(string) + '\"', element);
                literalExpression.replace((PsiElement)newExpression);
            } else if (element instanceof PsiMethodCallExpression) {
                Property property;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiMethod method = methodCallExpression.resolveMethod();
                PsiExpression returnValue = PropertyUtil.getGetterReturnExpression((PsiMethod)method);
                if (returnValue != null) {
                    this.doFix(project, (PsiElement)returnValue);
                }
                if ((property = TitleCapitalizationInspection.getPropertyArgument(methodCallExpression)) == null) {
                    return;
                }
                String value = property.getUnescapedValue();
                if (value == null) {
                    return;
                }
                property.setValue(this.fixValue(value));
            } else if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (variable.hasModifierProperty("final")) {
                    this.doFix(project, (PsiElement)variable.getInitializer());
                }
            }
        }

        private String fixValue(String string) {
            return this.myCapitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)string) : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)string));
        }

        protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
            PsiFile containingPsiFile = problemElement.getContainingFile();
            if (containingPsiFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingPsiFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            Project project = problemElement.getProject();
            ReadonlyStatusHandler handler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = handler.ensureFilesWritable(new VirtualFile[]{virtualFile});
            return status.hasReadonlyFiles();
        }

        public String getFamilyName() {
            return "Properly capitalize";
        }
    }
}

