/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.RemovePropertyLocalFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DuplicatedPropertiesInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    public String getName() {
        return "REPORT_DUPLICATED_PROPERTIES";
    }

    @Override
    public String getPresentableName() {
        return InspectionsBundle.message((String)"inconsistent.bundle.report.duplicate.properties.values", (Object[])new Object[0]);
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            if (parent == null) continue;
            Set<String> parentKeys = keysUpToParent.get(parent);
            THashSet overriddenKeys = new THashSet(propertiesFilesNamesMaps.get(file).keySet());
            overriddenKeys.retainAll(parentKeys);
            for (String overriddenKey : overriddenKeys) {
                IProperty property = file.findPropertyByKey(overriddenKey);
                assert (property != null);
                while (parent != null) {
                    IProperty parentProperty = parent.findPropertyByKey(overriddenKey);
                    if (parentProperty != null && Comparing.strEqual((String)property.getValue(), (String)parentProperty.getValue())) {
                        String message = InspectionsBundle.message((String)"inconsistent.bundle.property.inherited.with.the.same.value", (Object[])new Object[]{parent.getName()});
                        ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, (LocalQuickFix)RemovePropertyLocalFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
                        processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
                    }
                    parent = (PropertiesFile)parents.get((Object)parent);
                }
            }
        }
    }
}

