/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.DuplicatedPropertiesInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentPropertiesEndsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.MissingTranslationsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesKeysConsistencyInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesPlaceholdersInspectionProvider;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;

public class InconsistentResourceBundleInspection
extends GlobalSimpleInspectionTool {
    private static final Key<Set<ResourceBundle>> VISITED_BUNDLES_KEY = Key.create((String)"VISITED_BUNDLES_KEY");
    private final InconsistentResourceBundleInspectionProvider[] myInspectionProviders;
    private final Map<String, Boolean> mySettings = new LinkedHashMap<String, Boolean>();

    public InconsistentResourceBundleInspection() {
        this.myInspectionProviders = new InconsistentResourceBundleInspectionProvider[]{new PropertiesKeysConsistencyInspectionProvider(), new DuplicatedPropertiesInspectionProvider(), new MissingTranslationsInspectionProvider(), new PropertiesPlaceholdersInspectionProvider(), new InconsistentPropertiesEndsInspectionProvider()};
    }

    public String getGroupDisplayName() {
        return PropertiesBundle.message((String)"properties.files.inspection.group.display.name", (Object[])new Object[0]);
    }

    public String getDisplayName() {
        return InspectionsBundle.message((String)"inconsistent.resource.bundle.display.name", (Object[])new Object[0]);
    }

    public String getShortName() {
        return "InconsistentResourceBundle";
    }

    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(new OptionAccessor(){

            public boolean getOption(String optionName) {
                return InconsistentResourceBundleInspection.this.isProviderEnabled(optionName);
            }

            public void setOption(String optionName, boolean optionValue) {
                if (optionValue) {
                    InconsistentResourceBundleInspection.this.mySettings.remove(optionName);
                } else {
                    InconsistentResourceBundleInspection.this.mySettings.put(optionName, false);
                }
            }
        });
        for (InconsistentResourceBundleInspectionProvider provider : this.myInspectionProviders) {
            panel.addCheckbox(provider.getPresentableName(), provider.getName());
        }
        return panel;
    }

    public void writeSettings(Element node) throws WriteExternalException {
        for (Map.Entry<String, Boolean> e : this.mySettings.entrySet()) {
            JDOMExternalizerUtil.writeField((Element)node, (String)e.getKey(), (String)Boolean.toString(e.getValue()));
        }
    }

    public void readSettings(Element node) throws InvalidDataException {
        this.mySettings.clear();
        for (Element o : node.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element e = o;
            String name = e.getAttributeValue("name");
            boolean value = Boolean.parseBoolean(e.getAttributeValue("value"));
            this.mySettings.put(name, value);
        }
    }

    public void inspectionStarted(InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        globalContext.putUserData(VISITED_BUNDLES_KEY, (Object)new THashSet());
    }

    public void checkFile(PsiFile file, InspectionManager manager, ProblemsHolder problemsHolder, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Set visitedBundles = (Set)globalContext.getUserData(VISITED_BUNDLES_KEY);
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        assert (visitedBundles != null);
        if (!visitedBundles.add(resourceBundle)) {
            return;
        }
        List files = resourceBundle.getPropertiesFiles();
        if (files.size() < 2) {
            return;
        }
        BidirectionalMap parents = new BidirectionalMap();
        for (PropertiesFile f : files) {
            PropertiesFile parent = PropertiesUtil.getParent((PropertiesFile)f, (List)files);
            if (parent == null) continue;
            parents.put((Object)f, (Object)parent);
        }
        FactoryMap<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps = new FactoryMap<PropertiesFile, Map<String, String>>(){

            protected Map<String, String> create(PropertiesFile key) {
                return key.getNamesMap();
            }
        };
        THashMap keysUpToParent = new THashMap();
        for (PropertiesFile f : files) {
            THashSet keys = new THashSet(((Map)propertiesFilesNamesMaps.get((Object)f)).keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)f);
            while (parent != null) {
                keys.addAll(((Map)propertiesFilesNamesMaps.get((Object)parent)).keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
            }
            keysUpToParent.put(f, keys);
        }
        for (InconsistentResourceBundleInspectionProvider provider : this.myInspectionProviders) {
            if (!this.isProviderEnabled(provider.getName())) continue;
            provider.check((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, (Map<PropertiesFile, Map<String, String>>)propertiesFilesNamesMaps, manager, globalContext.getRefManager(), problemDescriptionsProcessor);
        }
    }

    private boolean isProviderEnabled(String providerName) {
        return (Boolean)ContainerUtil.getOrElse(this.mySettings, (Object)providerName, (Object)true);
    }

    public void enableProviders(Class<? extends InconsistentResourceBundleInspectionProvider> ... providerClasses) {
        HashSet providersToEnable = ContainerUtil.newHashSet((Object[])providerClasses);
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : this.myInspectionProviders) {
            if (!providersToEnable.contains(inspectionProvider.getClass())) continue;
            this.mySettings.put(inspectionProvider.getName(), true);
        }
    }

    public void disableAllProviders() {
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : this.myInspectionProviders) {
            this.mySettings.put(inspectionProvider.getName(), false);
        }
    }

    public void clearSettings() {
        this.mySettings.clear();
    }
}

