/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.psi.DefaultResourceBundleManager;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class ResourceBundleManager {
    private static final ExtensionPointName<ResourceBundleManager> RESOURCE_BUNDLE_MANAGER = ExtensionPointName.create((String)"com.intellij.java-i18n.resourceBundleManager");
    protected final Project myProject;

    protected ResourceBundleManager(Project project) {
        this.myProject = project;
    }

    public abstract PsiClass getResourceBundle();

    public List<String> suggestPropertiesFiles() {
        return I18nUtil.defaultGetPropertyFiles((Project)this.myProject);
    }

    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return null;
    }

    @NonNls
    public abstract String getTemplateName();

    @NonNls
    public abstract String getConcatenationTemplateName();

    public abstract boolean isActive(PsiFile var1) throws ResourceBundleNotFoundException;

    public abstract boolean canShowJavaCodeInfo();

    public static ResourceBundleManager getManager(PsiFile context) throws ResourceBundleNotFoundException {
        ResourceBundleManager[] managers;
        Project project = context.getProject();
        for (ResourceBundleManager manager : managers = (ResourceBundleManager[])project.getExtensions(RESOURCE_BUNDLE_MANAGER)) {
            if (!manager.isActive(context)) continue;
            return manager;
        }
        DefaultResourceBundleManager manager = new DefaultResourceBundleManager(project);
        return manager.isActive(context) ? manager : null;
    }

    public PropertyCreationHandler getPropertyCreationHandler() {
        return null;
    }

    public String suggestPropertyKey(String value) {
        return null;
    }

    public static class ResourceBundleNotFoundException
    extends Exception {
        private final IntentionAction myFix;

        public ResourceBundleNotFoundException(String message, IntentionAction setupResourceBundle) {
            super(message);
            this.myFix = setupResourceBundle;
        }

        public IntentionAction getFix() {
            return this.myFix;
        }
    }
}

