/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import icons.GithubIcons;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubOpenInBrowserAction
extends DumbAwareAction {
    public static final String CANNOT_OPEN_IN_BROWSER = "Cannot open in browser";

    protected GithubOpenInBrowserAction() {
        super("Open on GitHub", "Open corresponding link in browser", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault() || virtualFile == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        GitRepository gitRepository = (GitRepository)manager.getRepositoryForFile(virtualFile);
        if (gitRepository == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        if (!GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isUnversioned(virtualFile)) {
            GithubUtil.setVisibleEnabled(e, true, false);
            return;
        }
        Change change = changeListManager.getChange(virtualFile);
        if (change != null && change.getType() == Change.Type.NEW) {
            GithubUtil.setVisibleEnabled(e, true, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (virtualFile == null || project == null || project.isDisposed()) {
            return;
        }
        String urlToOpen = GithubOpenInBrowserAction.getGithubUrl(project, virtualFile, editor);
        if (urlToOpen != null) {
            BrowserUtil.browse((String)urlToOpen);
        }
    }

    private static String getGithubUrl(Project project, VirtualFile virtualFile, Editor editor) {
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        GitRepository repository = (GitRepository)manager.getRepositoryForFile(virtualFile);
        if (repository == null) {
            StringBuilder details = new StringBuilder("file: " + virtualFile.getPresentableUrl() + "; Git repositories: ");
            for (GitRepository repo : manager.getRepositories()) {
                details.append(repo.getPresentableUrl()).append("; ");
            }
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't find git repository", details.toString());
            return null;
        }
        String githubRemoteUrl = GithubUtil.findGithubRemoteUrl(repository);
        if (githubRemoteUrl == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't find github remote");
            return null;
        }
        String rootPath = repository.getRoot().getPath();
        String path = virtualFile.getPath();
        if (!path.startsWith(rootPath)) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "File is not under repository root", "Root: " + rootPath + ", file: " + path);
            return null;
        }
        String relativePath = path.substring(rootPath.length());
        String branch = GithubOpenInBrowserAction.getCurrentBranchNameOnRemote(repository);
        if (branch != null) {
            return GithubOpenInBrowserAction.makeUrlToOpen(editor, relativePath, branch, githubRemoteUrl);
        }
        String hash = GithubOpenInBrowserAction.getCurrentFileRevisionHash(project, virtualFile);
        if (hash != null) {
            return GithubOpenInBrowserAction.makeUrlToOpen(editor, relativePath, hash, githubRemoteUrl);
        }
        GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't find related tracked branch or hash.");
        return null;
    }

    private static String makeUrlToOpen(Editor editor, String relativePath, String branch, String githubRemoteUrl) {
        StringBuilder builder = new StringBuilder();
        String githubRepoUrl = GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(githubRemoteUrl);
        if (githubRepoUrl == null) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(githubRepoUrl).append("/tree/").append(branch);
        } else {
            builder.append(githubRepoUrl).append("/blob/").append(branch).append(relativePath);
        }
        if (editor != null && editor.getDocument().getLineCount() >= 1) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int begin = editor.getDocument().getLineNumber(selectionModel.getSelectionStart()) + 1;
            int selectionEnd = selectionModel.getSelectionEnd();
            int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
            if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                --end;
            }
            builder.append("#L").append(begin).append('-').append(end);
        }
        return builder.toString();
    }

    private static String getCurrentBranchNameOnRemote(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitRemoteBranch tracked = currentBranch.findTrackedBranch(repository);
        if (tracked == null) {
            return null;
        }
        return tracked.getNameForRemoteOperations();
    }

    private static String getCurrentFileRevisionHash(final Project project, final VirtualFile file) {
        final Ref ref = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Getting last revision", false){

            public void run(ProgressIndicator indicator) {
                try {
                    ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file), null)));
                }
                catch (VcsException e) {
                    GithubUtil.LOG.warn((Throwable)e);
                }
            }
        });
        if (ref.isNull()) {
            return null;
        }
        return ((GitRevisionNumber)ref.get()).getRev();
    }
}

