/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromAnnotateAction
extends GithubShowCommitInBrowserAction
implements LineNumberListener {
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public GithubShowCommitInBrowserFromAnnotateAction(FileAnnotation annotation) {
        this.myAnnotation = annotation;
    }

    public void update(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromAnnotateAction.calcData(e, this.myLineNumber);
        if (eventData == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
            return;
        }
        int corrected = eventData.getCorrectedLineNumber();
        e.getPresentation().setEnabled(corrected >= 0 && this.myAnnotation.getLineRevisionNumber(corrected) != null);
        e.getPresentation().setVisible(GithubUtil.isRepositoryOnGitHub(eventData.getRepository()));
    }

    public void actionPerformed(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromAnnotateAction.calcData(e, this.myLineNumber);
        if (eventData == null) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(eventData.getCorrectedLineNumber());
        if (revisionNumber != null) {
            GithubShowCommitInBrowserFromAnnotateAction.openInBrowser(eventData.getProject(), eventData.getRepository(), revisionNumber.asString());
        }
    }

    private static EventData calcData(AnActionEvent e, int lineNumber) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        UpToDateLineNumberProviderImpl myGetUpToDateLineNumber = new UpToDateLineNumberProviderImpl(document, project);
        int corrected = myGetUpToDateLineNumber.getLineNumber(lineNumber);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(virtualFile);
        if (repository == null) {
            return null;
        }
        return new EventData(project, repository, corrected);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }

    private static class EventData {
        private final Project myProject;
        private final GitRepository myRepository;
        private final int myCorrectedLineNumber;

        private EventData(Project project, GitRepository repository, int correctedLineNumber) {
            this.myProject = project;
            this.myRepository = repository;
            this.myCorrectedLineNumber = correctedLineNumber;
        }

        public Project getProject() {
            return this.myProject;
        }

        public GitRepository getRepository() {
            return this.myRepository;
        }

        private int getCorrectedLineNumber() {
            return this.myCorrectedLineNumber;
        }
    }
}

