/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.List;

public class GithubErrorMessage {
    public String message;
    public List<Error> errors;

    public String getMessage() {
        if (this.errors == null) {
            return this.message;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.message);
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        return s.toString();
    }

    public boolean containsReasonMessage(String reason) {
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(String code) {
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(String message) {
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message)) continue;
            return true;
        }
        return false;
    }

    public static class Error {
        public String resource;
        public String field;
        public String code;
        public String message;
    }
}

