/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubGist;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubGistRaw
implements DataConstructor {
    public String id;
    public String description;
    @SerializedName(value="public")
    public Boolean isPublic;
    public String url;
    public String htmlUrl;
    public String gitPullUrl;
    public String gitPushUrl;
    public Map<String, GistFileRaw> files;
    public GithubUserRaw owner;
    public Date createdAt;

    GithubGistRaw() {
    }

    public GithubGist createGist() {
        GithubUser user = this.owner == null ? null : this.owner.createUser();
        ArrayList<GithubGist.GistFile> files = new ArrayList<GithubGist.GistFile>();
        for (Map.Entry<String, GistFileRaw> entry : this.files.entrySet()) {
            files.add(entry.getValue().create());
        }
        return new GithubGist(this.id, this.description, this.isPublic, this.htmlUrl, files, user);
    }

    @Override
    public <T> T create(Class<T> resultClass) {
        if (resultClass == GithubGist.class) {
            return (T)this.createGist();
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class GistFileRaw {
        public Long size;
        public String filename;
        public String content;
        public String raw_url;
        public String type;
        public String language;

        public GithubGist.GistFile create() {
            return new GithubGist.GistFile(this.filename, this.content, this.raw_url);
        }
    }
}

