/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubRepo {
    private final String myName;
    private final String myDescription;
    private final boolean myIsPrivate;
    private final boolean myIsFork;
    private final String myHtmlUrl;
    private final String myCloneUrl;
    private final String myDefaultBranch;
    private final GithubUser myOwner;

    public GithubRepo(String name, String description, boolean isPrivate, boolean isFork, String htmlUrl, String cloneUrl, String defaultBranch, GithubUser owner) {
        this.myName = name;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPrivate = isPrivate;
        this.myIsFork = isFork;
        this.myHtmlUrl = htmlUrl;
        this.myCloneUrl = cloneUrl;
        this.myDefaultBranch = defaultBranch;
        this.myOwner = owner;
    }

    public String getName() {
        return this.myName;
    }

    public String getFullName() {
        return this.getUserName() + "/" + this.getName();
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean isPrivate() {
        return this.myIsPrivate;
    }

    public boolean isFork() {
        return this.myIsFork;
    }

    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    public String getCloneUrl() {
        return this.myCloneUrl;
    }

    public String getDefaultBranch() {
        return this.myDefaultBranch;
    }

    public GithubUser getOwner() {
        return this.myOwner;
    }

    public String getUserName() {
        return this.getOwner().getLogin();
    }

    public GithubFullPath getFullPath() {
        return new GithubFullPath(this.getUserName(), this.getName());
    }
}

