/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.GithubRepoOrg;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubRepoRaw
implements DataConstructor {
    public Long id;
    public String name;
    public String fullName;
    public String description;
    @SerializedName(value="private")
    public Boolean isPrivate;
    @SerializedName(value="fork")
    public Boolean isFork;
    public String url;
    public String htmlUrl;
    public String cloneUrl;
    public String gitUrl;
    public String sshUrl;
    public String svnUrl;
    public String mirrorUrl;
    public String homepage;
    public String language;
    public Integer size;
    public Integer forks;
    public Integer forksCount;
    public Integer watchers;
    public Integer watchersCount;
    public Integer openIssues;
    public Integer openIssuesCount;
    public String masterBranch;
    public String defaultBranch;
    public Boolean hasIssues;
    public Boolean hasWiki;
    public Boolean hasDownloads;
    public GithubRepoRaw parent;
    public GithubRepoRaw source;
    public GithubUserRaw owner;
    public GithubUserRaw organization;
    public Date pushedAt;
    public Date createdAt;
    public Date updatedAt;
    public Permissions permissions;

    GithubRepoRaw() {
    }

    public GithubRepo createRepo() {
        return new GithubRepo(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser());
    }

    public GithubRepoOrg createRepoOrg() {
        return new GithubRepoOrg(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser(), this.permissions.create());
    }

    public GithubRepoDetailed createRepoDetailed() {
        GithubRepo parent = this.parent == null ? null : this.parent.createRepo();
        GithubRepo source = this.source == null ? null : this.source.createRepo();
        return new GithubRepoDetailed(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser(), parent, source);
    }

    @Override
    public <T> T create(Class<T> resultClass) {
        if (resultClass == GithubRepo.class) {
            return (T)this.createRepo();
        }
        if (resultClass == GithubRepoOrg.class) {
            return (T)this.createRepoOrg();
        }
        if (resultClass == GithubRepoDetailed.class) {
            return (T)this.createRepoDetailed();
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class Permissions {
        public Boolean admin;
        public Boolean pull;
        public Boolean push;

        public GithubRepoOrg.Permissions create() {
            return new GithubRepoOrg.Permissions(this.admin, this.pull, this.push);
        }
    }
}

