/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import org.jetbrains.plugins.github.api.GithubUser;

public class GithubUserDetailed
extends GithubUser {
    private final String myName;
    private final String myEmail;
    private final Integer myOwnedPrivateRepos;
    private final String myType;
    private final UserPlan myPlan;

    public boolean canCreatePrivateRepo() {
        return this.getPlan() == null || this.getOwnedPrivateRepos() == null || this.getPlan().getPrivateRepos() > (long)this.getOwnedPrivateRepos().intValue();
    }

    public GithubUserDetailed(String login, String htmlUrl, String avatarUrl, String name, String email, Integer ownedPrivateRepos, String type, UserPlan plan) {
        super(login, htmlUrl, avatarUrl);
        this.myName = name;
        this.myEmail = email;
        this.myOwnedPrivateRepos = ownedPrivateRepos;
        this.myType = type;
        this.myPlan = plan;
    }

    public String getName() {
        return this.myName;
    }

    public String getEmail() {
        return this.myEmail;
    }

    public String getType() {
        return this.myType;
    }

    public Integer getOwnedPrivateRepos() {
        return this.myOwnedPrivateRepos;
    }

    public UserPlan getPlan() {
        return this.myPlan;
    }

    public static class UserPlan {
        private final String myName;
        private final long myPrivateRepos;

        public UserPlan(String name, long privateRepos) {
            this.myName = name;
            this.myPrivateRepos = privateRepos;
        }

        public String getName() {
            return this.myName;
        }

        public long getPrivateRepos() {
            return this.myPrivateRepos;
        }
    }
}

