/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskManagerImpl;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.tasks.GithubRepository;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory) {
        return false;
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }

    private static GithubFullPath getGithubProjectInfo(Project project) {
        GitRepository gitRepository = GithubUtil.getGitRepository(project, null);
        if (gitRepository == null) {
            return null;
        }
        String url = GithubUtil.findGithubRemoteUrl(gitRepository);
        if (url == null) {
            return null;
        }
        return GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
    }

    private static void processProject(final Project openedProject, final String author, final String name) {
        Runnable taskInitializationRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    GithubCheckoutListener.enableGithubTrackerIntegration(openedProject, author, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (openedProject.isInitialized()) {
            taskInitializationRunnable.run();
        } else {
            StartupManager.getInstance((Project)openedProject).runWhenProjectIsInitialized(taskInitializationRunnable);
        }
    }

    private static void enableGithubTrackerIntegration(Project project, String author, String name) {
        TaskRepository[] allRepositories;
        TaskManagerImpl manager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        for (TaskRepository repository : allRepositories = manager.getAllRepositories()) {
            if (!(repository instanceof GithubRepository)) continue;
            return;
        }
        GithubRepository repository = new GithubRepository(new GithubRepositoryType());
        repository.setToken("");
        repository.setRepoAuthor(author);
        repository.setRepoName(name);
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>(Arrays.asList(allRepositories));
        repositories.add((TaskRepository)repository);
        manager.setRepositories(repositories);
    }
}

