/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubAuthDataHolder {
    private GithubAuthData myAuthData;

    public GithubAuthDataHolder(GithubAuthData auth) {
        this.myAuthData = auth;
    }

    public synchronized GithubAuthData getAuthData() {
        return this.myAuthData;
    }

    public synchronized <T extends Throwable> void runTransaction(GithubAuthData expected, ThrowableComputable<GithubAuthData, T> task) throws T {
        if (expected != this.myAuthData) {
            return;
        }
        this.myAuthData = (GithubAuthData)task.compute();
    }

    public static GithubAuthDataHolder createFromSettings() {
        return new GithubAuthDataHolder(GithubSettings.getInstance().getAuthData());
    }
}

