/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubUrlUtil {
    public static String removeProtocolPrefix(String url) {
        int index = url.indexOf(64);
        if (index != -1) {
            return url.substring(index + 1).replace(':', '/');
        }
        index = url.indexOf("://");
        if (index != -1) {
            return url.substring(index + 3);
        }
        return url;
    }

    public static String removeTrailingSlash(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getApiUrl(String urlFromSettings) {
        return GithubUrlUtil.getApiProtocolFromUrl(urlFromSettings) + GithubUrlUtil.getApiUrlWithoutProtocol(urlFromSettings);
    }

    public static String getApiProtocol() {
        return GithubUrlUtil.getApiProtocolFromUrl(GithubSettings.getInstance().getHost());
    }

    public static String getApiProtocolFromUrl(String urlFromSettings) {
        if (StringUtil.startsWithIgnoreCase((String)urlFromSettings.trim(), (String)"http://")) {
            return "http://";
        }
        return "https://";
    }

    public static String getApiUrl() {
        return GithubUrlUtil.getApiUrl(GithubSettings.getInstance().getHost());
    }

    public static String getGithubHost() {
        return GithubUrlUtil.getApiProtocol() + GithubUrlUtil.getGitHostWithoutProtocol();
    }

    public static String getHostFromUrl(String url) {
        String path = GithubUrlUtil.removeProtocolPrefix(url).replace(':', '/');
        int index = path.indexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getGitHostWithoutProtocol() {
        return GithubUrlUtil.removeTrailingSlash(GithubUrlUtil.removeProtocolPrefix(GithubSettings.getInstance().getHost()));
    }

    public static String getApiUrlWithoutProtocol(String urlFromSettings) {
        String url = GithubUrlUtil.removeTrailingSlash(GithubUrlUtil.removeProtocolPrefix(urlFromSettings.toLowerCase()));
        String API_PREFIX = "api.";
        String ENTERPRISE_API_SUFFIX = "/api/v3";
        if (url.equals("github.com")) {
            return "api." + url;
        }
        if (url.equals("api.github.com")) {
            return url;
        }
        if (url.endsWith("/api/v3")) {
            return url;
        }
        return url + "/api/v3";
    }

    public static boolean isGithubUrl(String url) {
        return GithubUrlUtil.isGithubUrl(url, GithubSettings.getInstance().getHost());
    }

    public static boolean isGithubUrl(String url, String host) {
        host = GithubUrlUtil.getHostFromUrl(host);
        if (StringUtil.startsWithIgnoreCase((String)(url = GithubUrlUtil.removeProtocolPrefix(url)), (String)host)) {
            return url.length() <= host.length() || ":/".indexOf(url.charAt(host.length())) != -1;
        }
        return false;
    }

    public static GithubFullPath getUserAndRepositoryFromRemoteUrl(String remoteUrl) {
        int index1 = (remoteUrl = GithubUrlUtil.removeProtocolPrefix(GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47);
        if (index1 == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GithubFullPath(username, reponame);
    }

    public static String makeGithubRepoUrlFromRemoteUrl(String remoteUrl) {
        return GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(remoteUrl, GithubUrlUtil.getGithubHost());
    }

    public static String makeGithubRepoUrlFromRemoteUrl(String remoteUrl, String host) {
        GithubFullPath repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repo == null) {
            return null;
        }
        return host + '/' + repo.getUser() + '/' + repo.getRepository();
    }

    private static String removeEndingDotGit(String url) {
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            return url.substring(0, url.length() - ".git".length());
        }
        return url;
    }

    public static String getCloneUrl(GithubFullPath path) {
        return GithubUrlUtil.getCloneUrl(path.getUser(), path.getRepository());
    }

    public static String getCloneUrl(String user, String repo) {
        return GithubUrlUtil.getGithubHost() + "/" + user + "/" + repo + ".git";
    }
}

