/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ActionBackedModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class NonTransformedModelDslBacking
extends GroovyObjectSupport {
    public static final String ATTEMPTED_INPUT_SYNTAX_USED_MESSAGE = "$() syntax cannot be used when model {} block is not a top level statement in the script";
    private final ModelPath modelPath;
    private final ModelRegistry modelRegistry;
    private final ModelSchemaStore modelSchemaStore;
    private final ModelCreatorFactory modelCreatorFactory;
    private AtomicBoolean executingDsl;

    public NonTransformedModelDslBacking(ModelRegistry modelRegistry, ModelSchemaStore modelSchemaStore, ModelCreatorFactory modelCreatorFactory) {
        this(new AtomicBoolean(), null, modelRegistry, modelSchemaStore, modelCreatorFactory);
    }

    private NonTransformedModelDslBacking(AtomicBoolean executingDsl, ModelPath modelPath, ModelRegistry modelRegistry, ModelSchemaStore modelSchemaStore, ModelCreatorFactory modelCreatorFactory) {
        this.executingDsl = executingDsl;
        this.modelPath = modelPath;
        this.modelRegistry = modelRegistry;
        this.modelSchemaStore = modelSchemaStore;
        this.modelCreatorFactory = modelCreatorFactory;
    }

    private NonTransformedModelDslBacking getChildPath(String name) {
        ModelPath path = this.modelPath == null ? ModelPath.path((String)name) : this.modelPath.child(name);
        return new NonTransformedModelDslBacking(this.executingDsl, path, this.modelRegistry, this.modelSchemaStore, this.modelCreatorFactory);
    }

    private void registerConfigurationAction(Closure<?> action) {
        this.modelRegistry.configure(ModelActionRole.Mutate, (ModelAction)new ActionBackedModelAction(ModelReference.untyped((ModelPath)this.modelPath), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("model." + this.modelPath), (Action)new ClosureBackedAction(action)));
    }

    private <T> void registerCreator(Class<T> type, Closure<?> closure) {
        SimpleModelRuleDescriptor descriptor = new SimpleModelRuleDescriptor("model." + this.modelPath);
        ModelSchema schema = this.modelSchemaStore.getSchema(ModelType.of(type));
        if (!schema.getKind().isManaged()) {
            throw new InvalidModelRuleDeclarationException((ModelRuleDescriptor)descriptor, "Cannot create an element of type " + type.getName() + " as it is not a managed type");
        }
        this.modelRegistry.create(this.modelCreatorFactory.creator((ModelRuleDescriptor)descriptor, this.modelPath, schema, (Action)new ClosureBackedAction(closure)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Closure<?> action) {
        this.executingDsl.set(true);
        try {
            new ClosureBackedAction(action).execute((Object)this);
        }
        finally {
            this.executingDsl.set(false);
        }
    }

    public NonTransformedModelDslBacking propertyMissing(String name) {
        if (!this.executingDsl.get()) {
            throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
        }
        return this.getChildPath(name);
    }

    public Void methodMissing(String name, Object argsObj) {
        Object[] args = (Object[])argsObj;
        if (!this.executingDsl.get()) {
            if (name.equals("$")) {
                throw new GradleException(ATTEMPTED_INPUT_SYNTAX_USED_MESSAGE);
            }
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
        }
        if (args.length == 1 && args[0] instanceof Closure) {
            Closure closure = (Closure)args[0];
            this.getChildPath(name).registerConfigurationAction(closure);
            return null;
        }
        if (args.length == 2 && args[0] instanceof Class && args[1] instanceof Closure) {
            Class clazz = (Class)args[0];
            Closure closure = (Closure)args[1];
            this.getChildPath(name).registerCreator(clazz, closure);
            return null;
        }
        if (args.length == 1 && args[0] instanceof Class) {
            Class clazz = (Class)args[0];
            Closure closure = Closure.IDENTITY;
            this.getChildPath(name).registerCreator(clazz, closure);
            return null;
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
    }
}

