/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.inputs;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.dsl.internal.inputs.RuleInputAccess;
import org.gradle.model.internal.core.ModelView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class RuleInputAccessBacking {
    private static final ThreadLocal<Map<String, Object>> INPUT = new ThreadLocal();

    private RuleInputAccessBacking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(List<ModelView<?>> views, Runnable runnable) {
        HashMap map = Maps.newHashMap();
        int i = 0;
        for (ModelView<?> view : views) {
            map.put(view.getPath().toString(), views.get(i++).getInstance());
        }
        INPUT.set(map);
        try {
            runnable.run();
        }
        finally {
            INPUT.remove();
        }
    }

    public static RuleInputAccess getAccess() {
        final Map<String, Object> inputs = INPUT.get();
        return new RuleInputAccess(){

            public Object input(String modelPath) {
                return inputs.get(modelPath);
            }
        };
    }
}

