/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.model.dsl.internal.inputs.RuleInputAccess;
import org.gradle.model.dsl.internal.inputs.RuleInputAccessBacking;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.ModelPath;

@NotThreadSafe
public class RuleVisitor
extends CodeVisitorSupport {
    public static final String INVALID_ARGUMENT_LIST = "argument list must be exactly 1 literal non empty string";
    private static final String AST_NODE_METADATA_INPUTS_KEY = RuleVisitor.class.getName() + ".inputs";
    public static final String AST_NODE_METADATA_LOCATION_KEY = RuleVisitor.class.getName() + ".location";
    private static final String DOLLAR = "$";
    private static final String INPUT = "input";
    private static final ClassNode ANNOTATION_CLASS_NODE = new ClassNode(RuleMetadata.class);
    private static final ClassNode CONTEXTUAL_INPUT_TYPE = new ClassNode(RuleInputAccessBacking.class);
    private static final ClassNode ACCESS_API_TYPE = new ClassNode(RuleInputAccess.class);
    private static final String GET_ACCESS = "getAccess";
    private static final String ACCESS_HOLDER_FIELD = "_" + RuleInputAccess.class.getName().replace(".", "_");
    private final SourceUnit sourceUnit;
    private ImmutableListMultimap.Builder<String, Integer> inputs;
    private VariableExpression accessVariable;

    public RuleVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode method = AstUtils.getGeneratedClosureImplMethod((ClassNode)node);
        Statement closureCode = method.getCode();
        SourceLocation sourceLocation = (SourceLocation)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY);
        if (sourceLocation != null) {
            AnnotationNode metadataAnnotation = new AnnotationNode(ANNOTATION_CLASS_NODE);
            metadataAnnotation.addMember("scriptSourceDescription", (Expression)new ConstantExpression((Object)sourceLocation.getScriptSourceDescription()));
            metadataAnnotation.addMember("lineNumber", (Expression)new ConstantExpression((Object)sourceLocation.getLineNumber()));
            metadataAnnotation.addMember("columnNumber", (Expression)new ConstantExpression((Object)sourceLocation.getColumnNumber()));
            ListMultimap inputs = (ListMultimap)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY);
            if (!inputs.isEmpty()) {
                ArrayList pathValues = Lists.newArrayListWithCapacity((int)inputs.size());
                ArrayList lineNumberValues = Lists.newArrayListWithCapacity((int)inputs.size());
                for (Map.Entry input : Multimaps.asMap((ListMultimap)inputs).entrySet()) {
                    pathValues.add(new ConstantExpression(input.getKey()));
                    lineNumberValues.add(new ConstantExpression(((List)input.getValue()).get(0)));
                }
                metadataAnnotation.addMember("inputPaths", (Expression)new ListExpression((List)pathValues));
                metadataAnnotation.addMember("inputLineNumbers", (Expression)new ListExpression((List)lineNumberValues));
            }
            node.addAnnotation(metadataAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClosureExpression(ClosureExpression expression) {
        if (this.inputs == null) {
            this.inputs = ImmutableListMultimap.builder();
            try {
                this.accessVariable = new VariableExpression(ACCESS_HOLDER_FIELD, ACCESS_API_TYPE);
                super.visitClosureExpression(expression);
                BlockStatement code = (BlockStatement)expression.getCode();
                code.setNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY, (Object)this.inputs.build());
                this.accessVariable.setClosureSharedVariable(true);
                StaticMethodCallExpression getAccessCall = new StaticMethodCallExpression(CONTEXTUAL_INPUT_TYPE, GET_ACCESS, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                DeclarationExpression variableDeclaration = new DeclarationExpression(this.accessVariable, new Token(100, "=", -1, -1), (Expression)getAccessCall);
                code.getStatements().add(0, new ExpressionStatement((Expression)variableDeclaration));
                code.getVariableScope().putDeclaredVariable((Variable)this.accessVariable);
            }
            finally {
                this.inputs = null;
            }
        } else {
            expression.getVariableScope().putReferencedLocalVariable((Variable)this.accessVariable);
            super.visitClosureExpression(expression);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        String methodName = call.getMethodAsString();
        if (call.isImplicitThis() && methodName != null && methodName.equals(DOLLAR)) {
            this.visitInputMethod(call);
        } else {
            super.visitMethodCallExpression(call);
        }
    }

    private void visitInputMethod(MethodCallExpression call) {
        ConstantExpression argExpression = AstUtils.hasSingleConstantStringArg((MethodCallExpression)call);
        if (argExpression == null) {
            this.error((ASTNode)call, INVALID_ARGUMENT_LIST);
        } else {
            String modelPath = argExpression.getText();
            if (modelPath.isEmpty()) {
                this.error((ASTNode)argExpression, INVALID_ARGUMENT_LIST);
                return;
            }
            try {
                ModelPath.validatePath((String)modelPath);
            }
            catch (ModelPath.InvalidPathException e) {
                String message = "Invalid model path given as rule input." + SystemProperties.getInstance().getLineSeparator() + "  > " + e.getMessage();
                if (e.getCause() != null) {
                    message = message + SystemProperties.getInstance().getLineSeparator() + "    > " + e.getCause().getMessage();
                }
                this.error((ASTNode)argExpression, message);
                return;
            }
            this.inputs.put((Object)modelPath, (Object)call.getLineNumber());
            call.setObjectExpression((Expression)new VariableExpression((Variable)this.accessVariable));
            call.setMethod((Expression)new ConstantExpression((Object)INPUT));
        }
    }

    private void error(ASTNode call, String message) {
        SyntaxException syntaxException = new SyntaxException(message, call.getLineNumber(), call.getColumnNumber());
        this.sourceUnit.getErrorCollector().addError(syntaxException, this.sourceUnit);
    }
}

