/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.DefaultLanguageRegistry;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.collection.internal.BridgedCollections;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecContainer;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public ComponentModelBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        DefaultComponentSpecContainer components = (DefaultComponentSpecContainer)project.getExtensions().create("componentSpecs", DefaultComponentSpecContainer.class, new Object[]{this.instantiator});
        String descriptor = ComponentModelBasePlugin.class.getName() + ".apply()";
        BridgedCollections.dynamicTypes((ModelRegistry)this.modelRegistry, (ModelPath)ModelPath.path((String)"components"), (String)descriptor, (ModelType)ModelType.of(DefaultComponentSpecContainer.class), (ModelType)ModelType.of(DefaultComponentSpecContainer.class), (ModelType)ModelType.of(ComponentSpec.class), (PolymorphicDomainObjectContainerInternal)components, (Namer)Named.Namer.INSTANCE, (Transformer)BridgedCollections.itemDescriptor((String)descriptor));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentSourcesRegistrationAction<U extends LanguageSourceSet>
    implements Action<ComponentSpec> {
        private final LanguageRegistration<U> languageRegistration;
        private final LanguageTransformContainer languageTransforms;

        private ComponentSourcesRegistrationAction(LanguageRegistration<U> registration, LanguageTransformContainer languageTransforms) {
            this.languageRegistration = registration;
            this.languageTransforms = languageTransforms;
        }

        public static <U extends LanguageSourceSet> ComponentSourcesRegistrationAction<U> create(LanguageRegistration<U> registration, LanguageTransformContainer languageTransforms) {
            return new ComponentSourcesRegistrationAction<U>(registration, languageTransforms);
        }

        public void execute(ComponentSpec componentSpec) {
            ComponentSpecInternal componentSpecInternal = (ComponentSpecInternal)componentSpec;
            this.registerLanguageSourceSetFactory(componentSpecInternal);
            this.createDefaultSourceSetForComponents(componentSpecInternal);
        }

        void registerLanguageSourceSetFactory(ComponentSpecInternal component) {
            FunctionalSourceSet functionalSourceSet = component.getSources();
            NamedDomainObjectFactory<U> sourceSetFactory = this.languageRegistration.getSourceSetFactory(functionalSourceSet.getName());
            functionalSourceSet.registerFactory(this.languageRegistration.getSourceSetType(), sourceSetFactory);
        }

        void createDefaultSourceSetForComponents(ComponentSpecInternal component) {
            FunctionalSourceSet functionalSourceSet = component.getSources();
            Iterator i$ = this.languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform languageTransform = (LanguageTransform)i$.next();
                if (!languageTransform.getSourceSetType().equals(this.languageRegistration.getSourceSetType()) || !component.getInputTypes().contains(languageTransform.getOutputType())) continue;
                functionalSourceSet.maybeCreate(this.languageRegistration.getName(), this.languageRegistration.getSourceSetType());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        LanguageRegistry languages(ServiceRegistry serviceRegistry) {
            return (LanguageRegistry)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultLanguageRegistry.class, new Object[0]);
        }

        @Model
        LanguageTransformContainer languageTransforms(ServiceRegistry serviceRegistry) {
            return (LanguageTransformContainer)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultLanguageTransformContainer.class, new Object[0]);
        }

        @Defaults
        void initializeSourceSetsForComponents(CollectionBuilder<ComponentSpec> components, LanguageRegistry languageRegistry, LanguageTransformContainer languageTransforms) {
            Iterator i$ = languageRegistry.iterator();
            while (i$.hasNext()) {
                LanguageRegistration languageRegistration = (LanguageRegistration)i$.next();
                components.beforeEach(ComponentSourcesRegistrationAction.create(languageRegistration, languageTransforms));
            }
        }

        @Mutate
        void closeComponentsForBinaries(CollectionBuilder<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(final TaskContainer tasks, BinaryContainer binaries, LanguageTransformContainer languageTransforms) {
            Iterator i$ = languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform language = (LanguageTransform)i$.next();
                for (final BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                    if (binary.isLegacyBinary() || !language.applyToBinary(binary)) continue;
                    final SourceTransformTaskConfig taskConfig = language.getTransformTask();
                    binary.getSource().withType(language.getSourceSetType(), (Action)new Action<LanguageSourceSet>(){

                        public void execute(LanguageSourceSet languageSourceSet) {
                            LanguageSourceSetInternal sourceSet = (LanguageSourceSetInternal)languageSourceSet;
                            if (sourceSet.getMayHaveSources()) {
                                String taskName = taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getName()) + StringUtils.capitalize((String)sourceSet.getFullName());
                                Task task = tasks.create(taskName, taskConfig.getTaskType());
                                taskConfig.configureTask(task, binary, sourceSet);
                                task.dependsOn(new Object[]{sourceSet});
                                binary.getTasks().add(task);
                            }
                        }
                    });
                }
            }
        }

        @Mutate
        void applyDefaultSourceConventions(CollectionBuilder<ComponentSpec> componentSpecs) {
            componentSpecs.afterEach((Action)new Action<ComponentSpec>(){

                public void execute(ComponentSpec componentSpec) {
                    for (LanguageSourceSet languageSourceSet : componentSpec.getSource()) {
                        if (!languageSourceSet.getSource().getSrcDirs().isEmpty()) continue;
                        languageSourceSet.getSource().srcDir((Object)String.format("src/%s/%s", componentSpec.getName(), languageSourceSet.getName()));
                    }
                }
            });
        }

        @Mutate
        void closeSourcesForBinaries(BinaryContainer binaries, ProjectSourceSet sources) {
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Model
        PlatformResolvers platformResolver(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformResolvers)instantiator.newInstance(DefaultPlatformResolvers.class, new Object[]{platforms});
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }
    }
}

