/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.BiAction;
import org.gradle.internal.BiActions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.internal.BridgedCollections;
import org.gradle.model.internal.core.BiActionBackedModelAction;
import org.gradle.model.internal.core.DirectNodeModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryContainer;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LanguageBasePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public LanguageBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project target) {
        target.getPluginManager().apply(LifecycleBasePlugin.class);
        target.getExtensions().create("sources", DefaultProjectSourceSet.class, new Object[0]);
        DefaultBinaryContainer binaries = (DefaultBinaryContainer)target.getExtensions().create("binaries", DefaultBinaryContainer.class, new Object[]{this.instantiator});
        LanguageBasePlugin.applyRules(this.modelRegistry, binaries);
    }

    private static void applyRules(ModelRegistry modelRegistry, DefaultBinaryContainer binaries) {
        String descriptor = LanguageBasePlugin.class.getName() + ".apply()";
        SimpleModelRuleDescriptor ruleDescriptor = new SimpleModelRuleDescriptor(descriptor);
        ModelPath binariesPath = ModelPath.path((String)"binaries");
        BridgedCollections.dynamicTypes((ModelRegistry)modelRegistry, (ModelPath)binariesPath, (String)descriptor, (ModelType)ModelType.of(DefaultBinaryContainer.class), (ModelType)ModelType.of(DefaultBinaryContainer.class), (ModelType)ModelType.of(BinarySpec.class), (PolymorphicDomainObjectContainerInternal)binaries, (Namer)Named.Namer.INSTANCE, (Transformer)BridgedCollections.itemDescriptor((String)descriptor));
        modelRegistry.configure(ModelActionRole.Defaults, DirectNodeModelAction.of((ModelReference)ModelReference.of((ModelPath)binariesPath), (ModelRuleDescriptor)ruleDescriptor, (Action)new Action<MutableModelNode>((ModelRuleDescriptor)ruleDescriptor, descriptor){
            final /* synthetic */ ModelRuleDescriptor val$ruleDescriptor;
            final /* synthetic */ String val$descriptor;
            {
                this.val$ruleDescriptor = modelRuleDescriptor;
                this.val$descriptor = string;
            }

            public void execute(MutableModelNode binariesNode) {
                binariesNode.applyToAllLinks(ModelActionRole.Finalize, (ModelAction)BiActionBackedModelAction.single((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)this.val$ruleDescriptor, (ModelReference)ModelReference.of(ITaskFactory.class), (BiAction)new BiAction<BinarySpec, ITaskFactory>(){

                    public void execute(BinarySpec binary, ITaskFactory taskFactory) {
                        if (!((BinarySpecInternal)binary).isLegacyBinary()) {
                            TaskInternal binaryLifecycleTask = (TaskInternal)taskFactory.create(binary.getName(), DefaultTask.class);
                            binaryLifecycleTask.setGroup("build");
                            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                            binary.setBuildTask((Task)binaryLifecycleTask);
                        }
                    }
                }));
                binariesNode.applyToAllLinks(ModelActionRole.Initialize, DirectNodeModelAction.of((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor(this.val$descriptor + ".tasks"), (Action)new Action<MutableModelNode>(){

                    public void execute(MutableModelNode modelNode) {
                        ModelPath binaryPath = modelNode.getPath();
                        ModelPath taskNodePath = binaryPath.child("__tasks");
                        ModelType taskCollectionType = ModelTypes.collectionOf(Task.class);
                        ModelReference tasksNodeReference = ModelReference.of((ModelPath)taskNodePath, (ModelType)taskCollectionType);
                        modelNode.addLink(ModelCreators.of((ModelReference)tasksNodeReference, (BiAction)BiActions.doNothing()).withProjection((ModelProjection)new UnmanagedModelProjection(taskCollectionType)).descriptor(val$descriptor + ".createTasksNode").build());
                        MutableModelNode link = modelNode.getLink(taskNodePath.getName());
                        assert (link != null);
                        link.setPrivateData(taskCollectionType, (Object)((BinarySpec)modelNode.getPrivateData(ModelType.of(BinarySpec.class))).getTasks());
                    }
                }));
            }
        }));
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        ProjectSourceSet sources(ExtensionContainer extensions) {
            return (ProjectSourceSet)extensions.getByType(ProjectSourceSet.class);
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            Iterator i$ = binaries.iterator();
            while (i$.hasNext()) {
                BinarySpec binary = (BinarySpec)i$.next();
                tasks.addAll((Collection)((Object)binary.getTasks()));
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add((Object)buildTask);
            }
        }

        @Mutate
        void attachBinariesToAssembleLifecycle(@Path(value="tasks.assemble") Task assemble, BinaryContainer binaries) {
            ArrayList notBuildable = Lists.newArrayList();
            boolean hasBuildableBinaries = false;
            for (BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                if (binary.isLegacyBinary()) continue;
                if (binary.isBuildable()) {
                    assemble.dependsOn(new Object[]{binary});
                    hasBuildableBinaries = true;
                    continue;
                }
                notBuildable.add(binary);
            }
            if (!hasBuildableBinaries && !notBuildable.isEmpty()) {
                assemble.doFirst((Action)new CheckForNotBuildableBinariesAction(notBuildable));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckForNotBuildableBinariesAction
        implements Action<Task> {
            private final List<BinarySpecInternal> notBuildable;

            public CheckForNotBuildableBinariesAction(List<BinarySpecInternal> notBuildable) {
                this.notBuildable = notBuildable;
            }

            public void execute(Task task) {
                Set taskDependencies = task.getTaskDependencies().getDependencies(task);
                if (taskDependencies.isEmpty()) {
                    TreeFormatter formatter = new TreeFormatter();
                    formatter.node("No buildable binaries found");
                    formatter.startChildren();
                    for (BinarySpecInternal binary : this.notBuildable) {
                        formatter.node(binary.getName());
                        formatter.startChildren();
                        binary.getBuildAbility().explain((TreeVisitor<? super String>)formatter);
                        formatter.endChildren();
                    }
                    formatter.endChildren();
                    throw new GradleException(formatter.toString());
                }
            }
        }
    }
}

