/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary;

import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseBinarySpec
extends AbstractBuildableModelElement
implements BinarySpecInternal {
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private static ThreadLocal<BinaryInfo> nextBinaryInfo = new ThreadLocal();
    private final BinaryTasksCollection tasks;
    private final String name;
    private final String typeName;
    private boolean disabled;

    public static <T extends BaseBinarySpec> T create(Class<T> type, String name, Instantiator instantiator, ITaskFactory taskFactory) {
        if (type.equals(BaseBinarySpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseBinarySpec.");
        }
        nextBinaryInfo.set(new BinaryInfo(name, type.getSimpleName(), taskFactory, instantiator));
        try {
            BaseBinarySpec baseBinarySpec = (BaseBinarySpec)instantiator.newInstance(type, new Object[0]);
            return (T)baseBinarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create binary of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextBinaryInfo.set(null);
        }
    }

    protected BaseBinarySpec() {
        this(nextBinaryInfo.get());
    }

    private BaseBinarySpec(BinaryInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseBinarySpec is not permitted. Use a BinaryTypeBuilder instead.");
        }
        this.name = info.name;
        this.typeName = info.typeName;
        this.tasks = (BinaryTasksCollection)info.instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, info.taskFactory});
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.getTypeName(), this.getName());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.disabled = !buildable;
    }

    @Override
    public final boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    @Override
    public FunctionalSourceSet getBinarySources() {
        return this.sourceSets.getMainSources();
    }

    @Override
    public void setBinarySources(FunctionalSourceSet sources) {
        this.sourceSets.setMainSources(sources);
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets.getSources();
    }

    @Override
    public void sources(Action<? super PolymorphicDomainObjectContainer<LanguageSourceSet>> action) {
        action.execute((Object)this.sourceSets.getMainSources());
    }

    @Override
    public void source(Object source) {
        this.sourceSets.source(source);
    }

    @Override
    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    @Override
    public void tasks(Action<? super BinaryTasksCollection> action) {
        action.execute((Object)this.tasks);
    }

    @Override
    public boolean isLegacyBinary() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final BinaryBuildAbility getBuildAbility() {
        if (this.disabled) {
            return new FixedBuildAbility(false);
        }
        return this.getBinaryBuildAbility();
    }

    protected BinaryBuildAbility getBinaryBuildAbility() {
        return new FixedBuildAbility(true);
    }

    private static class BinaryInfo {
        private final String name;
        private final String typeName;
        private final ITaskFactory taskFactory;
        private final Instantiator instantiator;

        private BinaryInfo(String name, String typeName, ITaskFactory taskFactory, Instantiator instantiator) {
            this.name = name;
            this.typeName = typeName;
            this.taskFactory = taskFactory;
            this.instantiator = instantiator;
        }
    }
}

