/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.internal.ComponentSpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseComponentSpec
implements ComponentSpecInternal {
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();
    private final FunctionalSourceSet mainSourceSet;
    private final ComponentSpecIdentifier identifier;
    private final String typeName;
    private final DomainObjectSet<BinarySpec> binaries = new DefaultDomainObjectSet(BinarySpec.class);

    public static <T extends BaseComponentSpec> T create(Class<T> type, ComponentSpecIdentifier identifier, FunctionalSourceSet mainSourceSet, Instantiator instantiator) {
        if (type.equals(BaseComponentSpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseComponentSpec.");
        }
        nextComponentInfo.set(new ComponentInfo(identifier, type.getSimpleName(), mainSourceSet));
        try {
            BaseComponentSpec baseComponentSpec = (BaseComponentSpec)instantiator.newInstance(type, new Object[0]);
            return (T)baseComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    protected BaseComponentSpec() {
        this(nextComponentInfo.get());
    }

    private BaseComponentSpec(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a ComponentTypeBuilder instead.");
        }
        this.identifier = info.componentIdentifier;
        this.typeName = info.typeName;
        this.mainSourceSet = info.sourceSets;
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.getTypeName(), this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return new DefaultDomainObjectSet(LanguageSourceSet.class, (Collection)((Object)this.mainSourceSet));
    }

    @Override
    public DomainObjectSet<BinarySpec> getBinaries() {
        return this.binaries;
    }

    @Override
    public void binaries(Action<? super DomainObjectSet<BinarySpec>> action) {
        action.execute(this.binaries);
    }

    @Override
    public FunctionalSourceSet getSources() {
        return this.mainSourceSet;
    }

    @Override
    public void sources(Action<? super PolymorphicDomainObjectContainer<LanguageSourceSet>> action) {
        action.execute((Object)this.mainSourceSet);
    }

    @Override
    public Set<Class<? extends TransformationFileType>> getInputTypes() {
        return Collections.emptySet();
    }

    private static class ComponentInfo {
        final ComponentSpecIdentifier componentIdentifier;
        final String typeName;
        final FunctionalSourceSet sourceSets;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, String typeName, FunctionalSourceSet sourceSets) {
            this.componentIdentifier = componentIdentifier;
            this.typeName = typeName;
            this.sourceSets = sourceSets;
        }
    }
}

