/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.Cast;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.DefaultCollectionBuilder;
import org.gradle.model.internal.core.DirectNodeModelAction;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.CollectionBuilderBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTasksModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<BinaryTasks> {
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        return this.createRegistration(ruleDefinition);
    }

    private <R, S extends BinarySpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition) {
        try {
            AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector(this);
            this.verifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            final BinaryTaskRule binaryTaskRule = new BinaryTaskRule(binaryType, ruleDefinition);
            return new ExtractedModelAction(ModelActionRole.Defaults, (List)ImmutableList.of(ComponentModelBasePlugin.class), DirectNodeModelAction.of((ModelReference)ModelReference.of((String)"binaries"), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("binaries*.create()"), (Action)new Action<MutableModelNode>(){

                public void execute(MutableModelNode modelNode) {
                    modelNode.applyToAllLinks(ModelActionRole.Finalize, (ModelAction)binaryTaskRule);
                }
            }));
        }
        catch (InvalidModelException e) {
            throw this.invalidModelRule(ruleDefinition, e);
        }
    }

    private void verifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector taskDataCollector, MethodRuleDefinition<?, ?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitCollectionBuilderSubject(taskDataCollector, ruleDefinition, Task.class);
        this.visitDependency(taskDataCollector, ruleDefinition, ModelType.of(BinarySpec.class));
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid BinaryTask model rule method.");
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinaryTaskRule<R, T extends BinarySpec>
    extends CollectionBuilderBasedRule<R, Task, T, T> {
        public BinaryTaskRule(Class<T> binaryType, MethodRuleDefinition<R, ?> ruleDefinition) {
            super(ModelReference.of(binaryType), binaryType, ruleDefinition, new ModelReference[0]);
        }

        public void execute(MutableModelNode modelNode, final T binary, List<ModelView<?>> inputs) {
            DefaultCollectionBuilder<TaskInternal> collectionBuilder = new DefaultCollectionBuilder<TaskInternal>(ModelType.of(TaskInternal.class), this.getDescriptor(), modelNode, DefaultCollectionBuilder.createAndStoreVia((ModelReference)ModelReference.of(ITaskFactory.class), (ModelReference)ModelReference.of((ModelPath)modelNode.getPath().child("__tasks"), (ModelType)ModelTypes.collectionOf(Task.class)))){

                protected <S extends TaskInternal> void onCreate(String name, ModelType<S> type) {
                    Task task = (Task)this.get(name);
                    binary.builtBy(new Object[]{task});
                }
            };
            CollectionBuilder cast = (CollectionBuilder)Cast.uncheckedCast((Object)collectionBuilder);
            ArrayList inputsWithBinary = new ArrayList(inputs.size() + 1);
            inputsWithBinary.addAll(inputs);
            inputsWithBinary.add((ModelView<?>)new InstanceModelView(this.getSubject().getPath(), this.getSubject().getType(), binary));
            this.invoke(inputsWithBinary, cast, binary, binary);
        }
    }
}

